/*
 * Decompiled with CFR 0.152.
 */
package me.zipestudio.talkingheads.client;

import java.util.Optional;
import java.util.UUID;
import me.zipestudio.talkingheads.client.THClient;
import me.zipestudio.talkingheads.config.LeafyConfig;
import me.zipestudio.talkingheads.utils.talkingheads.AudioUtils;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.InjectPlasmoVoice;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.source.ClientSelfSourceInfo;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureProcessedEvent;
import su.plo.voice.api.client.event.audio.source.AudioSourceWriteEvent;
import su.plo.voice.api.client.event.connection.UdpClientPacketReceivedEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.player.VoicePlayerInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.clientbound.SelfAudioInfoPacket;

@Addon(id="pv-addon-talkingheads", name="Talking Heads", version="1.0.8", authors={"ZipeStudio"})
public class PlasmoVoiceAddon
implements AddonInitializer {
    @InjectPlasmoVoice
    private static PlasmoVoiceClient voiceClient;
    private double lastClientAudioLevel;

    public void onAddonInitialize() {
        System.out.println("pv-addon-talkingheads initialized");
    }

    @EventSubscribe
    public void onSourceWrite(@NotNull AudioSourceWriteEvent event) {
        LeafyConfig leafyConfig = THClient.getLeafyConfig();
        if (!leafyConfig.isEnableMod() || !leafyConfig.isUsePlasmoVoice()) {
            return;
        }
        SourceInfo sourceInfo = event.getSource().getSourceInfo();
        if (!(sourceInfo instanceof PlayerSourceInfo)) {
            return;
        }
        PlayerSourceInfo playerSourceInfo = (PlayerSourceInfo)sourceInfo;
        VoicePlayerInfo playerInfo = playerSourceInfo.getPlayerInfo();
        UUID uuid = playerInfo.getPlayerId();
        double audioLevel = AudioUtils.calculateAudioLevel(event.getSamples());
        AudioUtils.applyHeadVolume(uuid, audioLevel);
    }

    @EventSubscribe
    public void onSelfAudioPacket(@NotNull UdpClientPacketReceivedEvent event) {
        LeafyConfig leafyConfig = THClient.getLeafyConfig();
        if (!leafyConfig.isEnableMod() || !leafyConfig.isUsePlasmoVoice()) {
            return;
        }
        Packet packet = event.getPacket();
        if (!(packet instanceof SelfAudioInfoPacket)) {
            return;
        }
        SelfAudioInfoPacket infoPacket = (SelfAudioInfoPacket)packet;
        Optional selfSourceInfo = voiceClient.getSourceManager().getSelfSourceInfo(infoPacket.getSourceId());
        if (selfSourceInfo.isEmpty()) {
            return;
        }
        SourceInfo sourceInfo = ((ClientSelfSourceInfo)selfSourceInfo.get()).getSelfSourceInfo().getSourceInfo();
        if (!(sourceInfo instanceof PlayerSourceInfo)) {
            return;
        }
        PlayerSourceInfo playerSourceInfo = (PlayerSourceInfo)sourceInfo;
        VoicePlayerInfo playerInfo = playerSourceInfo.getPlayerInfo();
        UUID uuid = playerInfo.getPlayerId();
        double audioLevel = this.lastClientAudioLevel;
        AudioUtils.applyHeadVolume(uuid, audioLevel);
    }

    @EventSubscribe
    public void onAudioCapture(@NotNull AudioCaptureProcessedEvent event) {
        LeafyConfig leafyConfig = THClient.getLeafyConfig();
        if (!leafyConfig.isEnableMod() || !leafyConfig.isUsePlasmoVoice()) {
            return;
        }
        this.lastClientAudioLevel = AudioUtils.calculateAudioLevel(event.getProcessed().getMono());
    }

    public void onAddonShutdown() {
        System.out.println("Addon shut down");
    }

    public static PlasmoVoiceClient getVoiceClient() {
        return voiceClient;
    }
}

