/*
 * Decompiled with CFR 0.152.
 */
package net.velleagle.warfare_wings.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import immersive_aircraft.Main;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.velleagle.warfare_wings.entity.bullet.WWFBulletEntity;

public class WWFBulletEntityRenderer<T extends WWFBulletEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE = Main.locate((String)"textures/entity/bullet.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE);

    public WWFBulletEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.pushPose();
        float scale = ((WWFBulletEntity)((Object)entity)).getScale();
        matrixStack.scale(scale, scale, scale);
        matrixStack.translate(0.0, 0.5, 0.0);
        matrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose pose = matrixStack.last();
        VertexConsumer vertexConsumer = buffer.getBuffer(RENDER_TYPE);
        WWFBulletEntityRenderer.vertex(vertexConsumer, pose, packedLight, 0.0f, 0.0f, 0.0f, 1.0f);
        WWFBulletEntityRenderer.vertex(vertexConsumer, pose, packedLight, 1.0f, 0.0f, 1.0f, 1.0f);
        WWFBulletEntityRenderer.vertex(vertexConsumer, pose, packedLight, 1.0f, 1.0f, 1.0f, 0.0f);
        WWFBulletEntityRenderer.vertex(vertexConsumer, pose, packedLight, 0.0f, 1.0f, 0.0f, 0.0f);
        matrixStack.popPose();
        super.render(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose pose, int light, float x, float y, float u, float v) {
        vertexConsumer.addVertex(pose.pose(), x - 0.5f, y - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }
}

