/*
 * Decompiled with CFR 0.152.
 */
package net.velleagle.warfare_wings.entity.bullet;

import immersive_aircraft.config.Config;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WWFGBombUSEntity
extends PrimedTnt {
    private static final Logger LOGGER = LoggerFactory.getLogger(WWFGBombUSEntity.class);
    public static final float EXPLOSION_POWER = 10.0f;
    private static final int MAX_LIFETIME = 600;
    private static final double TORPEDO_SPEED = 1.0;
    private static final double DEPTH_FACTOR = 0.1;
    private boolean hasEnteredWater = false;
    private double dropHeight = 0.0;
    private double targetDepth = 0.0;
    private Vec3 torpedoDirection = Vec3.f_82478_;
    private int tickCount = 0;
    private boolean initialized = false;
    private float targetYaw = 0.0f;
    private float targetPitch = 0.0f;
    private boolean rotationLocked = false;

    public WWFGBombUSEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        this.m_6075_();
        ++this.tickCount;
        if (!this.initialized) {
            this.dropHeight = this.m_20186_();
            Vec3 motion = this.m_20184_();
            this.torpedoDirection = new Vec3(motion.f_82479_, 0.0, motion.f_82481_).m_82541_();
            this.initialized = true;
        }
        if (this.tickCount > 600) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                LOGGER.info("Torpedo exploding due to timeout");
                this.boom();
            }
            return;
        }
        boolean wasInWater = this.hasEnteredWater;
        boolean inWater = this.m_20069_();
        if (inWater && !wasInWater) {
            this.hasEnteredWater = true;
            double heightDifference = this.dropHeight - this.m_20186_();
            this.targetDepth = this.m_20186_() - heightDifference * 0.1;
            Vec3 motion = this.m_20184_();
            if (!motion.equals((Object)Vec3.f_82478_)) {
                this.targetYaw = (float)(Math.atan2(motion.f_82481_, motion.f_82479_) * 180.0 / Math.PI) - 90.0f;
                this.targetPitch = -10.0f;
                this.rotationLocked = true;
            }
            LOGGER.info("Torpedo entered water. Drop height: {}, Target depth: {}", (Object)this.dropHeight, (Object)this.targetDepth);
        }
        if (inWater && this.hasEnteredWater) {
            this.handleUnderwaterMovement();
        } else {
            this.handleAirMovement();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Vec3 motion = this.m_20184_();
        if (!motion.equals((Object)Vec3.f_82478_)) {
            if (inWater && this.hasEnteredWater && this.rotationLocked) {
                float yawDiff;
                if (this.m_20186_() <= this.targetDepth) {
                    this.targetPitch = 0.0f;
                }
                float currentYaw = this.m_146908_();
                float currentPitch = this.m_146909_();
                for (yawDiff = this.targetYaw - currentYaw; yawDiff > 180.0f; yawDiff -= 360.0f) {
                }
                while (yawDiff < -180.0f) {
                    yawDiff += 360.0f;
                }
                float newYaw = currentYaw + yawDiff * 0.3f;
                float newPitch = currentPitch + (this.targetPitch - currentPitch) * 0.3f;
                this.m_146922_(newYaw);
                this.m_146926_(newPitch);
            } else {
                float yaw = (float)(Math.atan2(motion.f_82481_, motion.f_82479_) * 180.0 / Math.PI) - 90.0f;
                float pitch = (float)(-(Math.atan2(motion.f_82480_, Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)) * 180.0 / Math.PI));
                this.m_146922_(yaw);
                this.m_146926_(pitch);
            }
        }
        if (this.f_19862_ || this.f_19863_) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                LOGGER.info("Torpedo exploding due to collision at {}, {}, {}", new Object[]{this.m_20185_(), this.m_20186_(), this.m_20189_()});
                this.boom();
            }
            return;
        }
        if (this.m_9236_().f_46443_ && inWater) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 0.5, this.m_20186_() + (this.f_19796_.m_188500_() - 0.5) * 0.5, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 0.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.m_9236_().f_46443_ && !inWater) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    private void handleAirMovement() {
        Vec3 motion = this.m_20184_();
        if (!this.m_20068_()) {
            motion = motion.m_82520_(0.0, -0.08, 0.0);
            double maxFallSpeed = -1.2;
            if (motion.f_82480_ < maxFallSpeed) {
                motion = new Vec3(motion.f_82479_, maxFallSpeed, motion.f_82481_);
            }
        }
        motion = motion.m_82490_(0.98);
        this.m_20256_(motion);
    }

    private void handleUnderwaterMovement() {
        double currentY = this.m_20186_();
        double verticalSpeed = currentY > this.targetDepth ? -0.15 : 0.02;
        if (this.torpedoDirection.equals((Object)Vec3.f_82478_)) {
            Vec3 currentMotion = this.m_20184_();
            this.torpedoDirection = new Vec3(currentMotion.f_82479_, 0.0, currentMotion.f_82481_).m_82541_();
        }
        Vec3 newMotion = this.torpedoDirection.m_82490_(1.0);
        newMotion = new Vec3(newMotion.f_82479_, verticalSpeed, newMotion.f_82481_);
        newMotion = newMotion.m_82490_(0.98);
        this.m_20256_(newMotion);
    }

    private void boom() {
        Level level;
        if (this.m_9236_().f_46443_) {
            LOGGER.warn("boom() called on client side - this should not happen!");
            return;
        }
        double x = this.m_20185_();
        double y = this.m_20227_(0.0625);
        double z = this.m_20189_();
        boolean isDestructive = Config.getInstance().weaponsAreDestructive;
        boolean isUnderwater = this.m_20069_();
        LOGGER.info("Torpedo exploding at {}, {}, {}. Destructive: {}, Underwater: {}", new Object[]{x, y, z, isDestructive, isUnderwater});
        if (isUnderwater && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LOGGER.info("Attempting underwater explosion with water removal");
            int radius = 11;
            ArrayList<BlockPos> waterPositions = new ArrayList<BlockPos>();
            int waterCount = 0;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        BlockPos pos = new BlockPos((int)Math.floor(x) + dx, (int)Math.floor(y) + dy, (int)Math.floor(z) + dz);
                        BlockState state = serverLevel.m_8055_(pos);
                        if (!state.m_60713_(Blocks.f_49990_) && !(state.m_60734_() instanceof LiquidBlock)) continue;
                        waterPositions.add(pos.m_7949_());
                        serverLevel.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
                        ++waterCount;
                    }
                }
            }
            LOGGER.info("Removed {} water blocks", (Object)waterCount);
            Explosion explosion = serverLevel.m_254849_((Entity)this, x, y, z, 10.0f, Level.ExplosionInteraction.TNT);
            LOGGER.info("Explosion created. Affected blocks: {}", (Object)(explosion != null ? explosion.m_46081_().size() : 0));
            this.spawnExplosionParticles(serverLevel, x, y, z, true);
            ArrayList finalWaterPositions = new ArrayList(waterPositions);
            serverLevel.m_7654_().execute(() -> {
                try {
                    Thread.sleep(1000L);
                    serverLevel.m_7654_().execute(() -> {
                        int restoredCount = 0;
                        for (BlockPos pos : finalWaterPositions) {
                            if (!serverLevel.m_8055_(pos).m_60795_()) continue;
                            serverLevel.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
                            ++restoredCount;
                        }
                        LOGGER.info("Restored {} water blocks", (Object)restoredCount);
                    });
                }
                catch (InterruptedException e) {
                    LOGGER.error("Water restoration interrupted", (Throwable)e);
                }
            });
        } else {
            LOGGER.info("Performing normal explosion");
            Explosion explosion = this.m_9236_().m_254849_((Entity)this, x, y, z, 10.0f, isDestructive ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.BLOCK);
            LOGGER.info("Normal explosion created. Affected blocks: {}", (Object)(explosion != null ? explosion.m_46081_().size() : 0));
            Level level2 = this.m_9236_();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                this.spawnExplosionParticles(serverLevel, x, y, z, isUnderwater);
            }
        }
    }

    private void spawnExplosionParticles(ServerLevel level, double x, double y, double z, boolean underwater) {
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        LOGGER.info("Spawning explosion particles at {}, {}, {}. Underwater: {}", new Object[]{x, y, z, underwater});
        int baseCount = 50;
        for (i = 0; i < baseCount; ++i) {
            offsetX = (this.f_19796_.m_188500_() - 0.5) * 10.0;
            offsetY = this.f_19796_.m_188500_() * 5.0;
            offsetZ = (this.f_19796_.m_188500_() - 0.5) * 10.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x + offsetX, y + offsetY, z + offsetZ, 5, 0.5, 0.5, 0.5, 0.0);
        }
        for (i = 0; i < baseCount * 3; ++i) {
            offsetX = (this.f_19796_.m_188500_() - 0.5) * 12.0;
            offsetY = this.f_19796_.m_188500_() * 6.0;
            offsetZ = (this.f_19796_.m_188500_() - 0.5) * 12.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, x + offsetX, y + offsetY, z + offsetZ, 10, 0.5, 0.5, 0.5, 0.1);
        }
        for (i = 0; i < baseCount * 2; ++i) {
            offsetX = (this.f_19796_.m_188500_() - 0.5) * 15.0;
            offsetY = this.f_19796_.m_188500_() * 7.0;
            offsetZ = (this.f_19796_.m_188500_() - 0.5) * 15.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x + offsetX, y + offsetY, z + offsetZ, 20, 0.3, 0.3, 0.3, 0.05);
        }
        for (i = 0; i < baseCount * 2; ++i) {
            offsetX = (this.f_19796_.m_188500_() - 0.5) * 8.0;
            offsetY = this.f_19796_.m_188500_() * 4.0;
            offsetZ = (this.f_19796_.m_188500_() - 0.5) * 8.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x + offsetX, y + offsetY, z + offsetZ, 10, 0.5, 0.5, 0.5, 0.1);
        }
        if (underwater) {
            for (i = 0; i < baseCount * 4; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 12.0;
                offsetY = this.f_19796_.m_188500_() * 6.0;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 12.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x + offsetX, y + offsetY, z + offsetZ, 20, 0.5, 0.5, 0.5, 0.2);
            }
            for (i = 0; i < baseCount; ++i) {
                offsetX = (this.f_19796_.m_188500_() - 0.5) * 10.0;
                offsetY = this.f_19796_.m_188500_() * 5.0;
                offsetZ = (this.f_19796_.m_188500_() - 0.5) * 10.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123772_, x + offsetX, y + offsetY, z + offsetZ, 10, 0.5, 0.5, 0.5, 0.1);
            }
        }
        LOGGER.info("Explosion particles spawned");
    }

    public boolean m_6783_(double distance) {
        double renderDistance = 4096.0;
        return distance < renderDistance;
    }
}

