/*
 * Decompiled with CFR 0.152.
 */
package net.velleagle.warfare_wings.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.velleagle.warfare_wings.WarfareWings;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class YAK3Scheme1Entity
extends AirplaneEntity {
    private float powerTime = 0.0f;
    private static final float POWER_THRESHOLD_TIME = 5.0f;
    private float GearState;
    private final List<Trail> trails = List.of(new Trail(40), new Trail(40));

    public YAK3Scheme1Entity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    public List<Trail> getTrails() {
        return this.trails;
    }

    protected void trail(Matrix4f transform, int index, float x, float y, float z) {
        Vector4f p0 = this.transformPosition(transform, x, y - 0.15f, z);
        Vector4f p1 = this.transformPosition(transform, x, y + 0.15f, z);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(Math.sqrt(this.m_20184_().m_82553_()) * (double)(0.5f + this.pressingInterpolatedX.getSmooth() * x * 0.025f) - 0.25)));
        this.getTrails().get(index).add(p0, p1, trailStrength);
    }

    public Item asItem() {
        return WarfareWings.YAK3_SCHEME1_ITEM.get();
    }

    public void m_8119_() {
        super.m_8119_();
        float enginePower = this.getEnginePower();
        float powerThreshold = 0.7f;
        this.powerTime = enginePower > powerThreshold ? (this.powerTime += 0.05f) : 0.0f;
        this.GearState = this.powerTime >= 5.0f ? 0.0f : 1.0f;
        if (this.m_9236_().f_46443_) {
            if (this.isWithinParticleRange()) {
                Matrix4f transform = this.getVehicleTransform();
                Matrix3f normalTransform = this.getVehicleNormalTransform();
                this.trail(transform, 0, -4.37f, 1.41f, -0.74f);
                this.trail(transform, 1, 4.37f, 1.41f, -0.74f);
                float power = this.getEnginePower();
                if ((double)power > 0.05) {
                    int i = 0;
                    while ((float)i < 1.0f + this.engineSpinUpStrength * 4.0f) {
                        Vector4f p = this.transformPosition(transform, 0.48f * (this.f_19797_ % 2 == 0 ? -1.0f : 1.0f), 1.85f, 0.72f);
                        Vector3f vel = this.transformVector(normalTransform, 0.2f * (this.f_19797_ % 2 == 0 ? -1.0f : 1.0f), 0.0f, 0.0f);
                        Vec3 velocity = this.m_20184_();
                        if ((double)this.f_19796_.m_188501_() < (double)this.engineSpinUpStrength * 0.1) {
                            vel.mul(0.5f);
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175834_, (double)p.x(), (double)p.y(), (double)p.z(), (double)vel.x() + velocity.f_82479_, (double)vel.y() + velocity.f_82480_, (double)vel.z() + velocity.f_82481_);
                        } else {
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)p.x, (double)p.y, (double)p.z, (double)vel.x + velocity.f_82479_, (double)vel.y + velocity.f_82480_, (double)vel.z + velocity.f_82481_);
                        }
                        ++i;
                    }
                }
            } else {
                this.trails.get(0).add(new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), 0.0f);
                this.trails.get(1).add(new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), 0.0f);
            }
        }
    }

    public double getZoom() {
        return 8.5;
    }

    public void setAnimationVariables(float tickDelta) {
        super.setAnimationVariables(tickDelta);
        BBAnimationVariables.set((String)"gear_state", (float)this.GearState);
    }

    protected float getEngineReactionSpeed() {
        return 100.0f;
    }
}

