/*
 * Decompiled with CFR 0.152.
 */
package net.velleagle.warfare_wings.entity.bullet;

import immersive_aircraft.config.Config;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1541;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WWFGBombUSEntity
extends class_1541 {
    private static final Logger LOGGER = LoggerFactory.getLogger(WWFGBombUSEntity.class);
    public static final float EXPLOSION_POWER = 10.0f;
    private static final int MAX_LIFETIME = 600;
    private static final double TORPEDO_SPEED = 1.0;
    private static final double DEPTH_FACTOR = 0.1;
    private boolean hasEnteredWater = false;
    private double dropHeight = 0.0;
    private double targetDepth = 0.0;
    private class_243 torpedoDirection = class_243.field_1353;
    private int tickCount = 0;
    private boolean initialized = false;
    private float targetYaw = 0.0f;
    private float targetPitch = 0.0f;
    private boolean rotationLocked = false;

    public WWFGBombUSEntity(class_1299 entityType, class_1937 level) {
        super(entityType, level);
    }

    public void method_5773() {
        this.method_5670();
        ++this.tickCount;
        if (!this.initialized) {
            this.dropHeight = this.method_23318();
            class_243 motion = this.method_18798();
            this.torpedoDirection = new class_243(motion.field_1352, 0.0, motion.field_1350).method_1029();
            this.initialized = true;
        }
        if (this.tickCount > 600) {
            this.method_31472();
            if (!this.method_37908().field_9236) {
                LOGGER.info("Torpedo exploding due to timeout");
                this.boom();
            }
            return;
        }
        boolean wasInWater = this.hasEnteredWater;
        boolean inWater = this.method_5799();
        if (inWater && !wasInWater) {
            this.hasEnteredWater = true;
            double heightDifference = this.dropHeight - this.method_23318();
            this.targetDepth = this.method_23318() - heightDifference * 0.1;
            class_243 motion = this.method_18798();
            if (!motion.equals((Object)class_243.field_1353)) {
                this.targetYaw = (float)(Math.atan2(motion.field_1350, motion.field_1352) * 180.0 / Math.PI) - 90.0f;
                this.targetPitch = -10.0f;
                this.rotationLocked = true;
            }
            LOGGER.info("Torpedo entered water. Drop height: {}, Target depth: {}", (Object)this.dropHeight, (Object)this.targetDepth);
        }
        if (inWater && this.hasEnteredWater) {
            this.handleUnderwaterMovement();
        } else {
            this.handleAirMovement();
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        class_243 motion = this.method_18798();
        if (!motion.equals((Object)class_243.field_1353)) {
            if (inWater && this.hasEnteredWater && this.rotationLocked) {
                float yawDiff;
                if (this.method_23318() <= this.targetDepth) {
                    this.targetPitch = 0.0f;
                }
                float currentYaw = this.method_36454();
                float currentPitch = this.method_36455();
                for (yawDiff = this.targetYaw - currentYaw; yawDiff > 180.0f; yawDiff -= 360.0f) {
                }
                while (yawDiff < -180.0f) {
                    yawDiff += 360.0f;
                }
                float newYaw = currentYaw + yawDiff * 0.3f;
                float newPitch = currentPitch + (this.targetPitch - currentPitch) * 0.3f;
                this.method_36456(newYaw);
                this.method_36457(newPitch);
            } else {
                float yaw = (float)(Math.atan2(motion.field_1350, motion.field_1352) * 180.0 / Math.PI) - 90.0f;
                float pitch = (float)(-(Math.atan2(motion.field_1351, Math.sqrt(motion.field_1352 * motion.field_1352 + motion.field_1350 * motion.field_1350)) * 180.0 / Math.PI));
                this.method_36456(yaw);
                this.method_36457(pitch);
            }
        }
        if (this.field_5976 || this.field_5992) {
            this.method_31472();
            if (!this.method_37908().field_9236) {
                LOGGER.info("Torpedo exploding due to collision at {}, {}, {}", new Object[]{this.method_23317(), this.method_23318(), this.method_23321()});
                this.boom();
            }
            return;
        }
        if (this.method_37908().field_9236 && inWater) {
            for (int i = 0; i < 3; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11247, this.method_23317() + (this.field_5974.method_43058() - 0.5) * 0.5, this.method_23318() + (this.field_5974.method_43058() - 0.5) * 0.5, this.method_23321() + (this.field_5974.method_43058() - 0.5) * 0.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.method_37908().field_9236 && !inWater) {
            this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    private void handleAirMovement() {
        class_243 motion = this.method_18798();
        if (!this.method_5740()) {
            motion = motion.method_1031(0.0, -0.08, 0.0);
            double maxFallSpeed = -1.2;
            if (motion.field_1351 < maxFallSpeed) {
                motion = new class_243(motion.field_1352, maxFallSpeed, motion.field_1350);
            }
        }
        motion = motion.method_1021(0.98);
        this.method_18799(motion);
    }

    private void handleUnderwaterMovement() {
        double currentY = this.method_23318();
        double verticalSpeed = currentY > this.targetDepth ? -0.15 : 0.02;
        if (this.torpedoDirection.equals((Object)class_243.field_1353)) {
            class_243 currentMotion = this.method_18798();
            this.torpedoDirection = new class_243(currentMotion.field_1352, 0.0, currentMotion.field_1350).method_1029();
        }
        class_243 newMotion = this.torpedoDirection.method_1021(1.0);
        newMotion = new class_243(newMotion.field_1352, verticalSpeed, newMotion.field_1350);
        newMotion = newMotion.method_1021(0.98);
        this.method_18799(newMotion);
    }

    private void boom() {
        class_1937 class_19372;
        if (this.method_37908().field_9236) {
            LOGGER.warn("boom() called on client side - this should not happen!");
            return;
        }
        double x = this.method_23317();
        double y = this.method_23323(0.0625);
        double z = this.method_23321();
        boolean isDestructive = Config.getInstance().weaponsAreDestructive;
        boolean isUnderwater = this.method_5799();
        LOGGER.info("Torpedo exploding at {}, {}, {}. Destructive: {}, Underwater: {}", new Object[]{x, y, z, isDestructive, isUnderwater});
        if (isUnderwater && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            LOGGER.info("Attempting underwater explosion with water removal");
            int radius = 11;
            ArrayList<class_2338> waterPositions = new ArrayList<class_2338>();
            int waterCount = 0;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        class_2338 pos = new class_2338((int)Math.floor(x) + dx, (int)Math.floor(y) + dy, (int)Math.floor(z) + dz);
                        class_2680 state = serverLevel.method_8320(pos);
                        if (!state.method_27852(class_2246.field_10382) && !(state.method_26204() instanceof class_2404)) continue;
                        waterPositions.add(pos.method_10062());
                        serverLevel.method_8652(pos, class_2246.field_10124.method_9564(), 18);
                        ++waterCount;
                    }
                }
            }
            LOGGER.info("Removed {} water blocks", (Object)waterCount);
            class_1927 explosion = serverLevel.method_8437((class_1297)this, x, y, z, 10.0f, class_1937.class_7867.field_40891);
            LOGGER.info("Explosion created. Affected blocks: {}", (Object)(explosion != null ? explosion.method_8346().size() : 0));
            this.spawnExplosionParticles(serverLevel, x, y, z, true);
            ArrayList finalWaterPositions = new ArrayList(waterPositions);
            serverLevel.method_8503().execute(() -> {
                try {
                    Thread.sleep(1000L);
                    serverLevel.method_8503().execute(() -> {
                        int restoredCount = 0;
                        for (class_2338 pos : finalWaterPositions) {
                            if (!serverLevel.method_8320(pos).method_26215()) continue;
                            serverLevel.method_8652(pos, class_2246.field_10382.method_9564(), 3);
                            ++restoredCount;
                        }
                        LOGGER.info("Restored {} water blocks", (Object)restoredCount);
                    });
                }
                catch (InterruptedException e) {
                    LOGGER.error("Water restoration interrupted", (Throwable)e);
                }
            });
        } else {
            LOGGER.info("Performing normal explosion");
            class_1927 explosion = this.method_37908().method_8437((class_1297)this, x, y, z, 10.0f, isDestructive ? class_1937.class_7867.field_40891 : class_1937.class_7867.field_40889);
            LOGGER.info("Normal explosion created. Affected blocks: {}", (Object)(explosion != null ? explosion.method_8346().size() : 0));
            class_1937 class_19373 = this.method_37908();
            if (class_19373 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19373;
                this.spawnExplosionParticles(serverLevel, x, y, z, isUnderwater);
            }
        }
    }

    private void spawnExplosionParticles(class_3218 level, double x, double y, double z, boolean underwater) {
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        LOGGER.info("Spawning explosion particles at {}, {}, {}. Underwater: {}", new Object[]{x, y, z, underwater});
        int baseCount = 50;
        for (i = 0; i < baseCount; ++i) {
            offsetX = (this.field_5974.method_43058() - 0.5) * 10.0;
            offsetY = this.field_5974.method_43058() * 5.0;
            offsetZ = (this.field_5974.method_43058() - 0.5) * 10.0;
            level.method_14199((class_2394)class_2398.field_11221, x + offsetX, y + offsetY, z + offsetZ, 5, 0.5, 0.5, 0.5, 0.0);
        }
        for (i = 0; i < baseCount * 3; ++i) {
            offsetX = (this.field_5974.method_43058() - 0.5) * 12.0;
            offsetY = this.field_5974.method_43058() * 6.0;
            offsetZ = (this.field_5974.method_43058() - 0.5) * 12.0;
            level.method_14199((class_2394)class_2398.field_11236, x + offsetX, y + offsetY, z + offsetZ, 10, 0.5, 0.5, 0.5, 0.1);
        }
        for (i = 0; i < baseCount * 2; ++i) {
            offsetX = (this.field_5974.method_43058() - 0.5) * 15.0;
            offsetY = this.field_5974.method_43058() * 7.0;
            offsetZ = (this.field_5974.method_43058() - 0.5) * 15.0;
            level.method_14199((class_2394)class_2398.field_11237, x + offsetX, y + offsetY, z + offsetZ, 20, 0.3, 0.3, 0.3, 0.05);
        }
        for (i = 0; i < baseCount * 2; ++i) {
            offsetX = (this.field_5974.method_43058() - 0.5) * 8.0;
            offsetY = this.field_5974.method_43058() * 4.0;
            offsetZ = (this.field_5974.method_43058() - 0.5) * 8.0;
            level.method_14199((class_2394)class_2398.field_11240, x + offsetX, y + offsetY, z + offsetZ, 10, 0.5, 0.5, 0.5, 0.1);
        }
        if (underwater) {
            for (i = 0; i < baseCount * 4; ++i) {
                offsetX = (this.field_5974.method_43058() - 0.5) * 12.0;
                offsetY = this.field_5974.method_43058() * 6.0;
                offsetZ = (this.field_5974.method_43058() - 0.5) * 12.0;
                level.method_14199((class_2394)class_2398.field_11247, x + offsetX, y + offsetY, z + offsetZ, 20, 0.5, 0.5, 0.5, 0.2);
            }
            for (i = 0; i < baseCount; ++i) {
                offsetX = (this.field_5974.method_43058() - 0.5) * 10.0;
                offsetY = this.field_5974.method_43058() * 5.0;
                offsetZ = (this.field_5974.method_43058() - 0.5) * 10.0;
                level.method_14199((class_2394)class_2398.field_11241, x + offsetX, y + offsetY, z + offsetZ, 10, 0.5, 0.5, 0.5, 0.1);
            }
        }
        LOGGER.info("Explosion particles spawned");
    }

    public boolean method_5640(double distance) {
        double renderDistance = 4096.0;
        return distance < renderDistance;
    }
}

