/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.premade.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;

public class RegistryObjectListConfig<T>
implements Iterable<T> {
    public final Registry<T> registry;
    private final List<RegistryHolder> content = new ArrayList<RegistryHolder>();

    public RegistryObjectListConfig(Registry<T> registry) {
        this.registry = registry;
    }

    public void add(ResourceLocation location) {
        if (!this.contains(location)) {
            this.content.add(new RegistryHolder(location));
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new FunctionIterator<Object>(this.content, x -> x.get());
    }

    public Iterable<ResourceLocation> locations() {
        return new FunctionIterator<ResourceLocation>(this.content, x -> x.location);
    }

    public boolean contains(ResourceLocation location) {
        for (int i = 0; i < this.content.size(); ++i) {
            if (!this.content.get((int)i).location.equals((Object)location)) continue;
            return true;
        }
        return false;
    }

    public ResourceLocation getLocation(int index) {
        return this.content.get((int)index).location;
    }

    public int size() {
        return this.content.size();
    }

    public class RegistryHolder {
        public final ResourceLocation location;
        private T cache;

        public RegistryHolder(ResourceLocation location) {
            this.location = location;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RegistryHolder) {
                RegistryHolder h = (RegistryHolder)obj;
                return h.location.equals((Object)this.location);
            }
            return super.equals(obj);
        }

        public T get() {
            if (this.cache == null) {
                this.cache = RegistryObjectListConfig.this.registry.get(this.location);
            }
            return this.cache;
        }
    }
}

