/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.SliceShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.unsafe.CreativeHackery;
import team.creative.creativecore.mixin.VoxelShapeAccessor;

public class BoxesVoxelShape
extends SliceShape {
    public static final DiscreteVoxelShape DISCRETE_SHAPE = new DiscreteVoxelShape(1, 1, 1){

        public boolean isFull(int x, int y, int z) {
            return true;
        }

        public void fill(int x, int y, int z) {
            throw new UnsupportedOperationException();
        }

        public int firstFull(Direction.Axis axis) {
            return 0;
        }

        public int lastFull(Direction.Axis axis) {
            return 1;
        }

        public boolean isEmpty() {
            return false;
        }
    };
    public List<ABB> boxes;

    public static BoxesVoxelShape create(List<ABB> boxes) {
        BoxesVoxelShape shape = CreativeHackery.allocateInstance(BoxesVoxelShape.class);
        shape.boxes = boxes;
        ((VoxelShapeAccessor)((Object)shape)).setShape(DISCRETE_SHAPE);
        return shape;
    }

    public static BoxesVoxelShape createVanilla(List<AABB> boxes) {
        ArrayList<ABB> converted = new ArrayList<ABB>(boxes.size());
        for (AABB bb : boxes) {
            converted.add(new ABB(bb));
        }
        return BoxesVoxelShape.create(converted);
    }

    public static BoxesVoxelShape create(ABB box) {
        return BoxesVoxelShape.create(new SingletonList<ABB>(box));
    }

    protected BoxesVoxelShape() {
        super(null, null, 0);
    }

    public VoxelShape move(double x, double y, double z) {
        ArrayList<ABB> boxes = new ArrayList<ABB>();
        for (ABB bb : this.boxes) {
            boxes.add(bb.moveCopy(x, y, z));
        }
        return BoxesVoxelShape.create(boxes);
    }

    public DoubleList getCoords(Direction.Axis axis) {
        DoubleArrayList list = new DoubleArrayList(this.boxes.size() * 2);
        for (ABB bb : this.boxes) {
            list.add(bb.min(axis));
            list.add(bb.max(axis));
        }
        list.sort(DoubleComparators.NATURAL_COMPARATOR);
        return list;
    }

    protected double get(Direction.Axis axis, int index) {
        throw new UnsupportedOperationException();
    }

    public double min(Direction.Axis axis) {
        double min = Double.POSITIVE_INFINITY;
        for (ABB bb : this.boxes) {
            min = Math.min(min, bb.min(axis));
        }
        return min;
    }

    public double max(Direction.Axis axis) {
        double max = Double.NEGATIVE_INFINITY;
        for (ABB bb : this.boxes) {
            max = Math.max(max, bb.max(axis));
        }
        return max;
    }

    public void forAllEdges(Shapes.DoubleLineConsumer consumer) {
        for (ABB bb : this.boxes) {
            for (BoxFace face : BoxFace.values()) {
                this.forAllEdgesCorner(bb, face.corners[0], face.corners[1], consumer);
                this.forAllEdgesCorner(bb, face.corners[1], face.corners[2], consumer);
                this.forAllEdgesCorner(bb, face.corners[2], face.corners[3], consumer);
                this.forAllEdgesCorner(bb, face.corners[3], face.corners[0], consumer);
            }
        }
    }

    private void forAllEdgesCorner(ABB bb, BoxCorner corner1, BoxCorner corner2, Shapes.DoubleLineConsumer consumer) {
        consumer.consume(bb.cornerX(corner1), bb.cornerY(corner1), bb.cornerZ(corner1), bb.cornerX(corner2), bb.cornerY(corner2), bb.cornerZ(corner2));
    }

    public void forAllBoxes(Shapes.DoubleLineConsumer consumer) {
        for (ABB bb : this.boxes) {
            consumer.consume(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
        }
    }

    public List<AABB> toAabbs() {
        ArrayList<AABB> bbs = new ArrayList<AABB>(this.boxes.size());
        for (ABB bb : this.boxes) {
            bbs.add(bb.toVanilla());
        }
        return bbs;
    }

    public double min(Direction.Axis axis, double one, double two) {
        Axis axisOne = Axis.X;
        Axis axisTwo = Axis.Z;
        double min = Double.POSITIVE_INFINITY;
        for (ABB bb : this.boxes) {
            if (!bb.intersectsWithAxis(axisOne, axisTwo, one, two)) continue;
            min = Math.min(min, bb.min(axis));
        }
        return min;
    }

    public double max(Direction.Axis axis, double one, double two) {
        Axis axisOne = Axis.X;
        Axis axisTwo = Axis.Z;
        double max = Double.NEGATIVE_INFINITY;
        for (ABB bb : this.boxes) {
            if (!bb.intersectsWithAxis(axisOne, axisTwo, one, two)) continue;
            max = Math.max(max, bb.max(axis));
        }
        return max;
    }

    protected int findIndex(Direction.Axis axis, double value) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public BlockHitResult clip(Vec3 pos, Vec3 look, BlockPos block) {
        return ABB.clip(this.boxes, pos, look, block);
    }

    public Optional<Vec3> closestPointTo(Vec3 vec) {
        Vec3 avec3 = null;
        for (ABB bb : this.boxes) {
            double d0 = Mth.clamp((double)vec.x(), (double)bb.minX, (double)bb.maxX);
            double d1 = Mth.clamp((double)vec.y(), (double)bb.minY, (double)bb.maxY);
            double d2 = Mth.clamp((double)vec.z(), (double)bb.minZ, (double)bb.maxZ);
            if (avec3 != null && !(vec.distanceToSqr(d0, d1, d2) < vec.distanceToSqr(avec3))) continue;
            avec3 = new Vec3(d0, d1, d2);
        }
        return Optional.of(avec3);
    }

    public VoxelShape getFaceShape(Direction direction) {
        return this;
    }

    public boolean isEmpty() {
        return this.boxes.isEmpty();
    }

    public VoxelShape optimize() {
        return this;
    }

    public boolean requiresAdvancedEntityStep() {
        for (ABB abb : this.boxes) {
            if (abb.getClass() == ABB.class) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsWith(AABB bb) {
        for (ABB abb : this.boxes) {
            if (!abb.intersectsPrecise(bb)) continue;
            return true;
        }
        return false;
    }

    public boolean onlyKeepIntersecting(AABB bb) {
        this.boxes.removeIf(x -> x.intersectsPrecise(bb));
        return !this.boxes.isEmpty();
    }

    public double collide(Direction.Axis axis, AABB other, double distance) {
        if (this.isEmpty()) {
            return distance;
        }
        if (Math.abs(distance) < 1.0E-7) {
            return 0.0;
        }
        Axis ltAxis = Axis.get(axis);
        Axis one = ltAxis.one();
        Axis two = ltAxis.two();
        for (ABB bb : this.boxes) {
            if (distance > 0.0) {
                distance = Math.min(distance, bb.calculateAxisOffset(ltAxis, one, two, other, distance));
                continue;
            }
            distance = Math.max(distance, bb.calculateAxisOffset(ltAxis, one, two, other, distance));
        }
        return distance;
    }

    protected double collideX(AxisCycle cycle, AABB other, double distance) {
        throw new UnsupportedOperationException();
    }

    public AABB bounds() {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (ABB bb : this.boxes) {
            minX = Math.min(minX, bb.minX);
            minY = Math.min(minY, bb.minY);
            minZ = Math.min(minZ, bb.minZ);
            maxX = Math.max(maxX, bb.maxX);
            maxY = Math.max(maxY, bb.maxY);
            maxZ = Math.max(maxZ, bb.maxZ);
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public String toString() {
        return "AABBListVoxelShape[" + String.valueOf(this.boxes) + "]";
    }
}

