/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class GuiRenderHelper {
    private static final class_310 mc = class_310.method_1551();

    public static class_327 getFont() {
        return GuiRenderHelper.mc.field_1772;
    }

    public static void drawItemStack(class_332 graphics, class_1799 stack, float alpha) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        graphics.method_51427(stack, 0, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawStringCentered(class_332 graphics, String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        int textWidth = GuiRenderHelper.mc.field_1772.method_1727((String)text);
        if ((float)textWidth > width && textWidth > (dotWith = GuiRenderHelper.mc.field_1772.method_1727("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < ((String)text).length() && (float)((charWidth = GuiRenderHelper.mc.field_1772.method_1727("" + ((String)text).charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(((String)text).charAt(i));
                textWidth += charWidth;
            }
            text = String.valueOf(builder) + "...";
        }
        class_327 class_3272 = GuiRenderHelper.mc.field_1772;
        int n = (int)(width / 2.0f - (float)(GuiRenderHelper.mc.field_1772.method_1727((String)text) / 2));
        float f = height / 2.0f;
        Objects.requireNonNull(GuiRenderHelper.mc.field_1772);
        graphics.method_51433(class_3272, (String)text, n, (int)(f - (float)(9 / 2)), -1, shadow);
    }

    public static void horizontalGradientRect(class_332 graphics, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        graphics.method_64039(buffer -> {
            class_4588 consumer = buffer.getBuffer(class_1921.method_51784());
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            boolean z = false;
            consumer.method_22918(matrix, (float)x2, (float)y, (float)z).method_39415(colorTo);
            consumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(colorFrom);
            consumer.method_22918(matrix, (float)x, (float)y2, (float)z).method_39415(colorFrom);
            consumer.method_22918(matrix, (float)x2, (float)y2, (float)z).method_39415(colorTo);
        });
    }

    public static void horizontalGradientRect(class_332 graphics, float x, float y, float x2, float y2, int colorFrom, int colorTo) {
        graphics.method_64039(buffer -> {
            class_4588 consumer = buffer.getBuffer(class_1921.method_51784());
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            boolean z = false;
            consumer.method_22918(matrix, x2, y, (float)z).method_39415(colorTo);
            consumer.method_22918(matrix, x, y, (float)z).method_39415(colorFrom);
            consumer.method_22918(matrix, x, y2, (float)z).method_39415(colorFrom);
            consumer.method_22918(matrix, x2, y2, (float)z).method_39415(colorTo);
        });
    }

    public static void verticalGradientRect(class_332 graphics, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        graphics.method_64039(source -> {
            class_4588 consumer = source.getBuffer(class_1921.method_51784());
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            boolean z = false;
            consumer.method_22918(matrix, (float)x2, (float)y, (float)z).method_39415(colorFrom);
            consumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(colorFrom);
            consumer.method_22918(matrix, (float)x, (float)y2, (float)z).method_39415(colorTo);
            consumer.method_22918(matrix, (float)x2, (float)y2, (float)z).method_39415(colorTo);
        });
    }

    public static void verticalGradientRect(class_332 graphics, float x, float y, float x2, float y2, int colorFrom, int colorTo) {
        graphics.method_64039(source -> {
            class_4588 consumer = source.getBuffer(class_1921.method_51784());
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            boolean z = false;
            consumer.method_22918(matrix, x2, y, (float)z).method_39415(colorFrom);
            consumer.method_22918(matrix, x, y, (float)z).method_39415(colorFrom);
            consumer.method_22918(matrix, x, y2, (float)z).method_39415(colorTo);
            consumer.method_22918(matrix, x2, y2, (float)z).method_39415(colorTo);
        });
    }

    public static void horizontalGradientMaskRect(class_332 graphics, int x, int y, int x2, int y2, int color, int mask) {
        GuiRenderHelper.horizontalGradientRect(graphics, x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    public static void horizontalGradientMaskRect(class_332 graphics, float x, float y, float x2, float y2, int color, int mask) {
        GuiRenderHelper.horizontalGradientRect(graphics, x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    public static void colorRect(class_332 graphics, int x, int y, int width, int height, int color) {
        graphics.method_64039(source -> {
            class_4588 consumer = source.getBuffer(class_1921.method_51784());
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            boolean z = false;
            consumer.method_22918(matrix, (float)x, (float)y, (float)z).method_39415(color);
            consumer.method_22918(matrix, (float)x, (float)(y + height), (float)z).method_39415(color);
            consumer.method_22918(matrix, (float)(x + width), (float)(y + height), (float)z).method_39415(color);
            consumer.method_22918(matrix, (float)(x + width), (float)y, (float)z).method_39415(color);
        });
    }

    public static void colorRect(class_332 graphics, float x, float y, float width, float height, int color) {
        graphics.method_64039(source -> {
            class_4588 consumer = source.getBuffer(class_1921.method_51784());
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            boolean z = false;
            consumer.method_22918(matrix, x, y, (float)z).method_39415(color);
            consumer.method_22918(matrix, x, y + height, (float)z).method_39415(color);
            consumer.method_22918(matrix, x + width, y + height, (float)z).method_39415(color);
            consumer.method_22918(matrix, x + width, y, (float)z).method_39415(color);
        });
    }

    public static void textureRect(class_332 graphics, class_2960 location, int x, int y, int width, int height, float u, float v) {
        int textureWidth = 256;
        int textureHeight = 256;
        GuiRenderHelper.drawTextureRect(graphics, location, x, x + width, y, y + height, 0, u / (float)textureWidth, (u + (float)width) / (float)textureWidth, v / (float)textureHeight, (v + (float)height) / (float)textureHeight);
    }

    public static void textureRect(class_332 graphics, class_2960 location, float x, float y, float width, float height, float u, float v) {
        int textureWidth = 256;
        int textureHeight = 256;
        GuiRenderHelper.drawTextureRect(graphics, location, x, x + width, y, y + height, 0.0f, u / (float)textureWidth, (u + width) / (float)textureWidth, v / (float)textureHeight, (v + height) / (float)textureHeight);
    }

    public static void textureRect(class_332 graphics, class_2960 location, int x, int y, int width, int height, float u, float v, float u2, float v2) {
        int textureWidth = 256;
        int textureHeight = 256;
        GuiRenderHelper.drawTextureRect(graphics, location, x, x + width, y, y + height, 0, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight);
    }

    public static void textureRect(class_332 graphics, class_2960 location, float x, float y, float width, float height, float u, float v, float u2, float v2) {
        int textureWidth = 256;
        int textureHeight = 256;
        GuiRenderHelper.drawTextureRect(graphics, location, x, x + width, y, y + height, 0.0f, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight);
    }

    private static void drawTextureRect(class_332 graphics, class_2960 location, int x, int x2, int y, int y2, int z, float u, float u2, float v, float v2) {
        class_1921 rendertype = class_1921.method_62277((class_2960)location);
        graphics.method_64039(consumer -> {
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            class_4588 vertexconsumer = consumer.getBuffer(rendertype);
            vertexconsumer.method_22918(matrix, (float)x, (float)y2, (float)z).method_22913(u, v2).method_39415(-1);
            vertexconsumer.method_22918(matrix, (float)x2, (float)y2, (float)z).method_22913(u2, v2).method_39415(-1);
            vertexconsumer.method_22918(matrix, (float)x2, (float)y, (float)z).method_22913(u2, v).method_39415(-1);
            vertexconsumer.method_22918(matrix, (float)x, (float)y, (float)z).method_22913(u, v).method_39415(-1);
        });
    }

    private static void drawTextureRect(class_332 graphics, class_2960 location, float x, float x2, float y, float y2, float z, float u, float u2, float v, float v2) {
        class_1921 rendertype = class_1921.method_62277((class_2960)location);
        graphics.method_64039(consumer -> {
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            class_4588 vertexconsumer = consumer.getBuffer(rendertype);
            vertexconsumer.method_22918(matrix, x, y2, z).method_22913(u, v2).method_39415(-1);
            vertexconsumer.method_22918(matrix, x2, y2, z).method_22913(u2, v2).method_39415(-1);
            vertexconsumer.method_22918(matrix, x2, y, z).method_22913(u2, v).method_39415(-1);
            vertexconsumer.method_22918(matrix, x, y, z).method_22913(u, v).method_39415(-1);
        });
    }
}

