/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.gui.GuiConfigControl;
import team.creative.creativecore.common.config.gui.GuiConfigSubControl;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.key.ConfigKeyType;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiPanel;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiConfigSubControlNested
extends GuiConfigSubControl {
    public ICreativeConfigHolder holder;
    public Object value;
    private final Runnable updateListener;
    private final Side side;
    private final GuiParent panel;

    public GuiConfigSubControlNested(String name, ICreativeConfigHolder holder, Object value, Side side, @Nullable Runnable updateListener, boolean invisiblePanel) {
        super(name);
        this.setExpandable();
        this.panel = invisiblePanel ? new GuiParent(GuiFlow.STACK_Y) : new GuiPanel(GuiFlow.STACK_Y);
        this.add((GuiControl)this.panel);
        this.holder = holder;
        this.value = value;
        this.side = side;
        this.updateListener = updateListener;
        this.flow = GuiFlow.STACK_Y;
        this.createControls();
    }

    public void load(ICreativeConfigHolder holder, Object value) {
        this.holder = holder;
        this.value = value;
    }

    @Override
    public void addNameUnmodifieable(String name) {
        this.nameLabel = new GuiLabel("title").setTitle((class_2561)class_2561.method_43470((String)name));
        this.panel.add((GuiControl)this.nameLabel);
    }

    @Override
    public void addNameTextfield(String name) {
        this.nameField = new GuiTextfield("title", name).setDim(50, 8);
        this.panel.add((GuiControl)this.nameField);
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    public void createControls() {
        for (ConfigKey configKey : this.holder.fields()) {
            GuiParent config;
            if (configKey.hideFromGUI) continue;
            String path = "config." + String.join((CharSequence)".", this.holder.path());
            if (!path.endsWith(".")) {
                path = path + ".";
            }
            String caption = GuiConfigSubControlNested.translateOrDefault(path + configKey.name + ".name", configKey.name);
            String comment = path + configKey.name + ".comment";
            if (configKey.isFolder()) {
                config = new GuiConfigSubControlNested(configKey.name, configKey.holder(), configKey.field().get(), this.side, this.updateListener, false);
                this.panel.add((GuiControl)config);
                ((GuiConfigSubControlNested)config).addNameUnmodifieable(caption);
                ((GuiConfigSubControlNested)config).createControls();
                continue;
            }
            config = new GuiConfigControl((ConfigKeyType)configKey, this.side, caption, comment){

                @Override
                public void updateButton() {
                    super.updateButton();
                    if (GuiConfigSubControlNested.this.updateListener != null) {
                        GuiConfigSubControlNested.this.updateListener.run();
                    }
                }
            };
            this.panel.add((GuiControl)config);
            ((GuiConfigControl)config).init(null);
        }
    }

    public JsonObject save() {
        JsonObject json = new JsonObject();
        for (GuiControl control : this.panel) {
            if (control instanceof GuiConfigControl) {
                GuiConfigControl c = (GuiConfigControl)control;
                JsonElement element = c.save();
                if (element == null) continue;
                json.add(c.field.name, element);
                continue;
            }
            if (!(control instanceof GuiConfigSubControlNested)) continue;
            GuiConfigSubControlNested n = (GuiConfigSubControlNested)control;
            json.add(n.name, (JsonElement)n.save());
        }
        this.holder.load(this.provider(), false, true, json, this.side);
        return this.holder.save(this.provider(), false, true, this.side);
    }
}

