/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_3532;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.list.TupleList;

public class GuiTabButton<K>
extends GuiParent {
    public static final ControlFormatting BUTTON_ACTIVE = new ControlFormatting(ControlFormatting.ControlStyleBorder.SMALL, 2, ControlFormatting.ControlStyleFace.CLICKABLE);
    public static final ControlFormatting BUTTON_INACTIVE = new ControlFormatting(ControlFormatting.ControlStyleBorder.SMALL, 2, ControlFormatting.ControlStyleFace.CLICKABLE_INACTIVE);
    protected TupleList<K, CompiledText> data;
    private List<GuiBorderlessButton> buttons;
    private int index;
    private GuiBorderlessButton<K> selected;

    public GuiTabButton(String name, IComponentMap states) {
        this(name, 0, states);
    }

    public GuiTabButton(String name, int index, IComponentMap map) {
        super(name, null);
        this.flow = GuiFlow.STACK_X;
        this.set(map);
        this.select(index);
    }

    public void set(IComponentMap<K> builder) {
        this.data = builder.build();
        this.buttons = new ArrayList<GuiBorderlessButton>();
        this.clear();
        int i = 0;
        for (Tuple tuple : this.data) {
            int bIndex = i;
            GuiBorderlessButton b = new GuiBorderlessButton("b" + i, x -> this.select(bIndex), tuple.key);
            this.add((GuiControl)b.setText((CompiledText)tuple.value));
            this.buttons.add(b);
            ++i;
        }
        this.select(this.index);
    }

    @Nullable
    public K selected() {
        if (this.selected != null) {
            return this.selected.value;
        }
        return null;
    }

    public K selected(K defaultValue) {
        K s = this.selected();
        if (s != null) {
            return s;
        }
        return defaultValue;
    }

    public void select(int index) {
        this.index = class_3532.method_15340((int)index, (int)0, (int)(this.data.size() - 1));
        if (this.selected != null) {
            this.selected.active = false;
        }
        if (!this.data.isEmpty()) {
            this.selected = this.buttons.get(index);
            this.selected.active = true;
        } else {
            this.selected = null;
        }
        this.raiseEvent(new GuiControlChangedEvent<GuiTabButton>(this));
    }

    public void select(K key) {
        this.select(this.indexOf(key));
    }

    public int indexOf(K key) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!Objects.equals(((Tuple)this.data.get((int)i)).key, key)) continue;
            return i;
        }
        return -1;
    }

    public void next() {
        int index = this.index + 1;
        if (index >= this.data.size()) {
            index = 0;
        }
        this.select(index);
    }

    public void previous() {
        int index = this.index - 1;
        if (index < 0) {
            index = this.data.size() - 1;
        }
        this.select(index);
    }

    public int index() {
        return this.index;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    public static class GuiBorderlessButton<K>
    extends GuiButton {
        public boolean active = false;
        private final K value;

        public GuiBorderlessButton(String name, Consumer<Integer> pressed, K value) {
            super(name, pressed);
            this.value = value;
        }

        @Override
        public ControlFormatting getControlFormatting() {
            if (this.active) {
                return BUTTON_ACTIVE;
            }
            return BUTTON_INACTIVE;
        }
    }
}

