/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Environment(value=EnvType.CLIENT)
public class GuiRenderHelper {
    private static final Minecraft mc = Minecraft.getInstance();

    public static Font getFont() {
        return GuiRenderHelper.mc.font;
    }

    public static void drawItemStack(GuiGraphics graphics, ItemStack stack, float alpha) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        graphics.renderItem(stack, 0, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawStringCentered(GuiGraphics graphics, String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        int textWidth = GuiRenderHelper.mc.font.width((String)text);
        if ((float)textWidth > width && textWidth > (dotWith = GuiRenderHelper.mc.font.width("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < ((String)text).length() && (float)((charWidth = GuiRenderHelper.mc.font.width("" + ((String)text).charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(((String)text).charAt(i));
                textWidth += charWidth;
            }
            text = String.valueOf(builder) + "...";
        }
        Font font = GuiRenderHelper.mc.font;
        int n = (int)(width / 2.0f - (float)(GuiRenderHelper.mc.font.width((String)text) / 2));
        float f = height / 2.0f;
        Objects.requireNonNull(GuiRenderHelper.mc.font);
        graphics.drawString(font, (String)text, n, (int)(f - (float)(9 / 2)), -1, shadow);
    }

    public static void horizontalGradientRect(GuiGraphics graphics, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        graphics.drawSpecial(buffer -> {
            VertexConsumer consumer = buffer.getBuffer(RenderType.gui());
            Matrix4f matrix = graphics.pose().last().pose();
            boolean z = false;
            consumer.addVertex(matrix, (float)x2, (float)y, (float)z).setColor(colorTo);
            consumer.addVertex(matrix, (float)x, (float)y, (float)z).setColor(colorFrom);
            consumer.addVertex(matrix, (float)x, (float)y2, (float)z).setColor(colorFrom);
            consumer.addVertex(matrix, (float)x2, (float)y2, (float)z).setColor(colorTo);
        });
    }

    public static void horizontalGradientRect(GuiGraphics graphics, float x, float y, float x2, float y2, int colorFrom, int colorTo) {
        graphics.drawSpecial(buffer -> {
            VertexConsumer consumer = buffer.getBuffer(RenderType.gui());
            Matrix4f matrix = graphics.pose().last().pose();
            boolean z = false;
            consumer.addVertex(matrix, x2, y, (float)z).setColor(colorTo);
            consumer.addVertex(matrix, x, y, (float)z).setColor(colorFrom);
            consumer.addVertex(matrix, x, y2, (float)z).setColor(colorFrom);
            consumer.addVertex(matrix, x2, y2, (float)z).setColor(colorTo);
        });
    }

    public static void verticalGradientRect(GuiGraphics graphics, int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        graphics.drawSpecial(source -> {
            VertexConsumer consumer = source.getBuffer(RenderType.gui());
            Matrix4f matrix = graphics.pose().last().pose();
            boolean z = false;
            consumer.addVertex(matrix, (float)x2, (float)y, (float)z).setColor(colorFrom);
            consumer.addVertex(matrix, (float)x, (float)y, (float)z).setColor(colorFrom);
            consumer.addVertex(matrix, (float)x, (float)y2, (float)z).setColor(colorTo);
            consumer.addVertex(matrix, (float)x2, (float)y2, (float)z).setColor(colorTo);
        });
    }

    public static void verticalGradientRect(GuiGraphics graphics, float x, float y, float x2, float y2, int colorFrom, int colorTo) {
        graphics.drawSpecial(source -> {
            VertexConsumer consumer = source.getBuffer(RenderType.gui());
            Matrix4f matrix = graphics.pose().last().pose();
            boolean z = false;
            consumer.addVertex(matrix, x2, y, (float)z).setColor(colorFrom);
            consumer.addVertex(matrix, x, y, (float)z).setColor(colorFrom);
            consumer.addVertex(matrix, x, y2, (float)z).setColor(colorTo);
            consumer.addVertex(matrix, x2, y2, (float)z).setColor(colorTo);
        });
    }

    public static void horizontalGradientMaskRect(GuiGraphics graphics, int x, int y, int x2, int y2, int color, int mask) {
        GuiRenderHelper.horizontalGradientRect(graphics, x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    public static void horizontalGradientMaskRect(GuiGraphics graphics, float x, float y, float x2, float y2, int color, int mask) {
        GuiRenderHelper.horizontalGradientRect(graphics, x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    public static void colorRect(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.drawSpecial(source -> {
            VertexConsumer consumer = source.getBuffer(RenderType.gui());
            Matrix4f matrix = graphics.pose().last().pose();
            boolean z = false;
            consumer.addVertex(matrix, (float)x, (float)y, (float)z).setColor(color);
            consumer.addVertex(matrix, (float)x, (float)(y + height), (float)z).setColor(color);
            consumer.addVertex(matrix, (float)(x + width), (float)(y + height), (float)z).setColor(color);
            consumer.addVertex(matrix, (float)(x + width), (float)y, (float)z).setColor(color);
        });
    }

    public static void colorRect(GuiGraphics graphics, float x, float y, float width, float height, int color) {
        graphics.drawSpecial(source -> {
            VertexConsumer consumer = source.getBuffer(RenderType.gui());
            Matrix4f matrix = graphics.pose().last().pose();
            boolean z = false;
            consumer.addVertex(matrix, x, y, (float)z).setColor(color);
            consumer.addVertex(matrix, x, y + height, (float)z).setColor(color);
            consumer.addVertex(matrix, x + width, y + height, (float)z).setColor(color);
            consumer.addVertex(matrix, x + width, y, (float)z).setColor(color);
        });
    }

    public static void textureRect(GuiGraphics graphics, ResourceLocation location, int x, int y, int width, int height, float u, float v) {
        int textureWidth = 256;
        int textureHeight = 256;
        GuiRenderHelper.drawTextureRect(graphics, location, x, x + width, y, y + height, 0, u / (float)textureWidth, (u + (float)width) / (float)textureWidth, v / (float)textureHeight, (v + (float)height) / (float)textureHeight);
    }

    public static void textureRect(GuiGraphics graphics, ResourceLocation location, float x, float y, float width, float height, float u, float v) {
        int textureWidth = 256;
        int textureHeight = 256;
        GuiRenderHelper.drawTextureRect(graphics, location, x, x + width, y, y + height, 0.0f, u / (float)textureWidth, (u + width) / (float)textureWidth, v / (float)textureHeight, (v + height) / (float)textureHeight);
    }

    public static void textureRect(GuiGraphics graphics, ResourceLocation location, int x, int y, int width, int height, float u, float v, float u2, float v2) {
        int textureWidth = 256;
        int textureHeight = 256;
        GuiRenderHelper.drawTextureRect(graphics, location, x, x + width, y, y + height, 0, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight);
    }

    public static void textureRect(GuiGraphics graphics, ResourceLocation location, float x, float y, float width, float height, float u, float v, float u2, float v2) {
        int textureWidth = 256;
        int textureHeight = 256;
        GuiRenderHelper.drawTextureRect(graphics, location, x, x + width, y, y + height, 0.0f, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight);
    }

    private static void drawTextureRect(GuiGraphics graphics, ResourceLocation location, int x, int x2, int y, int y2, int z, float u, float u2, float v, float v2) {
        RenderType rendertype = RenderType.guiTextured((ResourceLocation)location);
        graphics.drawSpecial(consumer -> {
            Matrix4f matrix = graphics.pose().last().pose();
            VertexConsumer vertexconsumer = consumer.getBuffer(rendertype);
            vertexconsumer.addVertex(matrix, (float)x, (float)y2, (float)z).setUv(u, v2).setColor(-1);
            vertexconsumer.addVertex(matrix, (float)x2, (float)y2, (float)z).setUv(u2, v2).setColor(-1);
            vertexconsumer.addVertex(matrix, (float)x2, (float)y, (float)z).setUv(u2, v).setColor(-1);
            vertexconsumer.addVertex(matrix, (float)x, (float)y, (float)z).setUv(u, v).setColor(-1);
        });
    }

    private static void drawTextureRect(GuiGraphics graphics, ResourceLocation location, float x, float x2, float y, float y2, float z, float u, float u2, float v, float v2) {
        RenderType rendertype = RenderType.guiTextured((ResourceLocation)location);
        graphics.drawSpecial(consumer -> {
            Matrix4f matrix = graphics.pose().last().pose();
            VertexConsumer vertexconsumer = consumer.getBuffer(rendertype);
            vertexconsumer.addVertex(matrix, x, y2, z).setUv(u, v2).setColor(-1);
            vertexconsumer.addVertex(matrix, x2, y2, z).setUv(u2, v2).setColor(-1);
            vertexconsumer.addVertex(matrix, x2, y, z).setUv(u2, v).setColor(-1);
            vertexconsumer.addVertex(matrix, x, y, z).setUv(u, v).setColor(-1);
        });
    }
}

