/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.text;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@Environment(value=EnvType.CLIENT)
public class DebugTextRenderer {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.##");
    protected final List<String> lines = new ArrayList<String>();

    private static String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return DECIMAL_FORMAT.format(value);
        }
        return value.toString();
    }

    public DebugTextRenderer() {
        this.lines.add("");
    }

    public DebugTextRenderer text(String text) {
        this.lines.set(this.lines.size() - 1, this.lines.get(this.lines.size() - 1) + text);
        return this;
    }

    public DebugTextRenderer detail(String name, Object value) {
        StringBuilder lastLine = new StringBuilder(this.lines.get(this.lines.size() - 1));
        if (!lastLine.isEmpty()) {
            lastLine.append(",");
        }
        if (name.isEmpty()) {
            lastLine.append(DebugTextRenderer.format(value));
        } else {
            lastLine.append(String.valueOf(ChatFormatting.YELLOW) + name + String.valueOf(ChatFormatting.RESET) + ":" + DebugTextRenderer.format(value));
        }
        this.lines.set(this.lines.size() - 1, lastLine.toString());
        return this;
    }

    public DebugTextRenderer newLine() {
        this.lines.add("");
        return this;
    }

    public void render(Font font, GuiGraphics graphics) {
        int top = 2;
        for (String msg : this.lines) {
            if (msg != null && !msg.isEmpty()) {
                int n = 2 + font.width(msg) + 1;
                Objects.requireNonNull(font);
                graphics.fill(1, top - 1, n, top + 9 - 1, -1873784752);
                graphics.drawString(font, msg, 2, top, 0xE0E0E0, false);
            }
            Objects.requireNonNull(font);
            top += 9;
        }
    }
}

