/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.creator;

import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.BlockGuiCreator;
import team.creative.creativecore.common.gui.creator.ItemGuiCreator;
import team.creative.creativecore.common.gui.integration.GuiScreenIntegration;
import team.creative.creativecore.common.gui.packet.OpenGuiPacket;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

public abstract class GuiCreator {
    public static final NamedHandlerRegistry<GuiCreator> REGISTRY = new NamedHandlerRegistry<Object>(null);
    public static final GuiCreatorItem ITEM_OPENER = GuiCreator.register("item", new GuiCreatorItem());
    public static final GuiCreatorBlock BLOCK_OPENER = GuiCreator.register("block", new GuiCreatorBlock());
    String name;
    public final BiFunction<CompoundTag, Player, GuiLayer> function;

    public static <T extends GuiCreator> T register(String name, T creator) {
        creator.name = name;
        REGISTRY.register(name, creator);
        return creator;
    }

    public GuiCreator(BiFunction<CompoundTag, Player, GuiLayer> function) {
        this.function = function;
    }

    public String getName() {
        return this.name;
    }

    protected void openGui(CompoundTag nbt, Player player) {
        if (player.level().isClientSide) {
            CreativeCore.NETWORK.sendToServer(new OpenGuiPacket(this.name, nbt));
        } else {
            OpenGuiPacket.openGuiOnServer(this, nbt, (ServerPlayer)player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public static void openClientSide(GuiLayer layer) {
        Minecraft.getInstance().forceSetScreen((Screen)new GuiScreenIntegration(layer));
    }

    public static class GuiCreatorItem
    extends GuiCreator {
        public GuiCreatorItem() {
            super((nbt, player) -> {
                InteractionHand hand = nbt.getBooleanOr("main_hand", false) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                ItemStack stack = player.getItemInHand(hand);
                Item patt0$temp = stack.getItem();
                if (patt0$temp instanceof ItemGuiCreator) {
                    ItemGuiCreator item = (ItemGuiCreator)patt0$temp;
                    return item.create((CompoundTag)nbt, (Player)player);
                }
                return null;
            });
        }

        public void open(Player player, InteractionHand hand) {
            this.open(new CompoundTag(), player, hand);
        }

        public void open(CompoundTag nbt, Player player, InteractionHand hand) {
            nbt.putBoolean("main_hand", hand == InteractionHand.MAIN_HAND);
            this.openGui(nbt, player);
        }
    }

    public static class GuiCreatorBlock
    extends GuiCreator {
        public GuiCreatorBlock() {
            super((nbt, player) -> {
                BlockPos pos = (BlockPos)nbt.read("pos", BlockPos.CODEC).get();
                Level level = player.level();
                BlockState state = level.getBlockState(pos);
                Block patt0$temp = state.getBlock();
                if (patt0$temp instanceof BlockGuiCreator) {
                    BlockGuiCreator block = (BlockGuiCreator)patt0$temp;
                    return block.create((CompoundTag)nbt, level, pos, state, (Player)player);
                }
                return null;
            });
        }

        public void open(Player player, BlockPos pos) {
            this.open(new CompoundTag(), player, pos);
        }

        public void open(CompoundTag nbt, Player player, BlockPos pos) {
            nbt.store("pos", BlockPos.CODEC, (Object)pos);
            this.openGui(nbt, player);
        }
    }

    public static class GuiCreatorBasic
    extends GuiCreator {
        public GuiCreatorBasic(BiFunction<CompoundTag, Player, GuiLayer> function) {
            super(function);
        }

        public void open(Player player) {
            this.openGui(new CompoundTag(), player);
        }

        public void open(CompoundTag nbt, Player player) {
            this.openGui(nbt, player);
        }
    }
}

