/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network.type;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3f;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.network.BundlePacketWrapper;
import team.creative.creativecore.common.network.CreativeByteBuf;
import team.creative.creativecore.common.network.CreativeNetworkUtils;
import team.creative.creativecore.common.network.type.NetworkFieldType;
import team.creative.creativecore.common.network.type.NetworkFieldTypeClass;
import team.creative.creativecore.common.network.type.NetworkFieldTypeSpecial;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.filter.Filter;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec1f;
import team.creative.creativecore.common.util.math.vec.Vec2d;
import team.creative.creativecore.common.util.math.vec.Vec2f;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.mc.ConnectionUtils;
import team.creative.creativecore.common.util.registry.exception.RegistryException;
import team.creative.creativecore.common.util.type.Bunch;
import team.creative.creativecore.common.util.type.itr.IterableIterator;
import team.creative.creativecore.common.util.type.itr.SingleIterator;

public class NetworkFieldTypes {
    private static final Gson GSON = new Gson();
    private static final List<NetworkFieldTypeSpecial> SPECIAL_PARSERS = new ArrayList<NetworkFieldTypeSpecial>();
    private static final HashMap<Class, NetworkFieldType> PARSERS = new HashMap();

    public static <T> void register(NetworkFieldType<T> parser, Class<T> classType) {
        PARSERS.put(classType, parser);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> registerAndCodec(NetworkFieldTypeClass<T> parser, Class<T> classType) {
        NetworkFieldTypes.register(parser, classType);
        return StreamCodec.of((x, y) -> parser.writeContent((Object)y, (RegistryFriendlyByteBuf)x), parser::readContent);
    }

    public static <T> void register(NetworkFieldType<T> parser, Class<? extends T> ... classType) {
        for (Class<? extends T> clazz : classType) {
            PARSERS.put(clazz, parser);
        }
    }

    public static <T> void register(NetworkFieldTypeSpecial parser) {
        SPECIAL_PARSERS.add(parser);
    }

    public static NetworkFieldType get(Field field) {
        return NetworkFieldTypes.get(field.getType(), field.getGenericType());
    }

    public static <T> NetworkFieldType<T> get(Class<T> classType) {
        try {
            NetworkFieldType parser = PARSERS.get(classType);
            if (parser != null) {
                return parser;
            }
        }
        catch (Exception e1) {
            CreativeCore.LOGGER.error((Object)e1);
        }
        throw new RuntimeException("No field type found for " + classType.getSimpleName());
    }

    public static NetworkFieldType get(Class classType, Type genericType) {
        try {
            NetworkFieldType parser = PARSERS.get(classType);
            if (parser != null) {
                return parser;
            }
            for (int i = 0; i < SPECIAL_PARSERS.size(); ++i) {
                if (!NetworkFieldTypes.SPECIAL_PARSERS.get((int)i).predicate.test(classType, genericType)) continue;
                return SPECIAL_PARSERS.get(i);
            }
        }
        catch (Exception e1) {
            CreativeCore.LOGGER.error((Object)e1);
        }
        throw new RuntimeException("No field type found for " + classType.getSimpleName());
    }

    public static <T> void write(Class<T> clazz, T object, CreativeByteBuf buffer, PacketFlow flow) {
        NetworkFieldTypes.get(clazz).write(object, clazz, null, buffer, flow);
    }

    public static <T> void writeMany(Class<T> clazz, Bunch<T> bunch, CreativeByteBuf buffer, PacketFlow flow) {
        buffer.writeInt(bunch.size());
        NetworkFieldType type = NetworkFieldTypes.get(clazz);
        for (Object t : bunch) {
            type.write(t, clazz, null, buffer, flow);
        }
    }

    public static <T> void writeMany(Class<T> clazz, Collection<T> collection, CreativeByteBuf buffer, PacketFlow flow) {
        buffer.writeInt(collection.size());
        NetworkFieldType<T> type = NetworkFieldTypes.get(clazz);
        for (T t : collection) {
            type.write(t, clazz, null, buffer, flow);
        }
    }

    public static <T> void writeMany(Class<T> clazz, T[] collection, CreativeByteBuf buffer, PacketFlow flow) {
        buffer.writeInt(collection.length);
        NetworkFieldType<T> type = NetworkFieldTypes.get(clazz);
        for (T t : collection) {
            type.write(t, clazz, null, buffer, flow);
        }
    }

    public static <T> T read(Class<T> clazz, CreativeByteBuf buffer, PacketFlow flow) {
        return NetworkFieldTypes.get(clazz).read(clazz, null, buffer, flow);
    }

    public static <T> Iterable<T> readMany(final Class<T> clazz, final CreativeByteBuf buffer, final PacketFlow flow) {
        final int length = buffer.readInt();
        final NetworkFieldType<T> type = NetworkFieldTypes.get(clazz);
        return new IterableIterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < length;
            }

            @Override
            public T next() {
                ++this.index;
                return type.read(clazz, null, buffer, flow);
            }
        };
    }

    public static void writeIntArray(int[] array, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            buffer.writeInt(array[i]);
        }
    }

    public static int[] readIntArray(RegistryFriendlyByteBuf buffer) {
        int[] array = new int[buffer.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = buffer.readInt();
        }
        return array;
    }

    static {
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Boolean>(){

            @Override
            protected void writeContent(Boolean content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBoolean(content.booleanValue());
            }

            @Override
            protected Boolean readContent(RegistryFriendlyByteBuf buffer) {
                return buffer.readBoolean();
            }
        }, Boolean.TYPE, Boolean.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Byte>(){

            @Override
            protected void writeContent(Byte content, RegistryFriendlyByteBuf buffer) {
                buffer.writeByte(content.byteValue());
            }

            @Override
            protected Byte readContent(RegistryFriendlyByteBuf buffer) {
                return buffer.readByte();
            }
        }, Byte.TYPE, Byte.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Short>(){

            @Override
            protected void writeContent(Short content, RegistryFriendlyByteBuf buffer) {
                buffer.writeShort((int)content.shortValue());
            }

            @Override
            protected Short readContent(RegistryFriendlyByteBuf buffer) {
                return buffer.readShort();
            }
        }, Short.TYPE, Short.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Integer>(){

            @Override
            protected void writeContent(Integer content, RegistryFriendlyByteBuf buffer) {
                buffer.writeInt(content.intValue());
            }

            @Override
            protected Integer readContent(RegistryFriendlyByteBuf buffer) {
                return buffer.readInt();
            }
        }, Integer.TYPE, Integer.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Long>(){

            @Override
            protected void writeContent(Long content, RegistryFriendlyByteBuf buffer) {
                buffer.writeLong(content.longValue());
            }

            @Override
            protected Long readContent(RegistryFriendlyByteBuf buffer) {
                return buffer.readLong();
            }
        }, Long.TYPE, Long.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Float>(){

            @Override
            protected void writeContent(Float content, RegistryFriendlyByteBuf buffer) {
                buffer.writeFloat(content.floatValue());
            }

            @Override
            protected Float readContent(RegistryFriendlyByteBuf buffer) {
                return Float.valueOf(buffer.readFloat());
            }
        }, Float.TYPE, Float.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Double>(){

            @Override
            protected void writeContent(Double content, RegistryFriendlyByteBuf buffer) {
                buffer.writeDouble(content.doubleValue());
            }

            @Override
            protected Double readContent(RegistryFriendlyByteBuf buffer) {
                return buffer.readDouble();
            }
        }, Double.TYPE, Double.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<BlockPos>(){

            @Override
            protected void writeContent(BlockPos content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBlockPos(content);
            }

            @Override
            protected BlockPos readContent(RegistryFriendlyByteBuf buffer) {
                return buffer.readBlockPos();
            }
        }, BlockPos.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<String>(){

            @Override
            protected void writeContent(String content, RegistryFriendlyByteBuf buffer) {
                buffer.writeUtf(content);
            }

            @Override
            protected String readContent(RegistryFriendlyByteBuf buffer) {
                return buffer.readUtf(Short.MAX_VALUE);
            }
        }, String.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Component>(){

            @Override
            protected void writeContent(Component content, RegistryFriendlyByteBuf buffer) {
                FriendlyByteBuf.writeNullable((ByteBuf)buffer, (Object)content, (StreamEncoder)ComponentSerialization.STREAM_CODEC);
            }

            @Override
            protected Component readContent(RegistryFriendlyByteBuf buffer) {
                return (Component)FriendlyByteBuf.readNullable((ByteBuf)buffer, (StreamDecoder)ComponentSerialization.STREAM_CODEC);
            }
        }, Component.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<CompoundTag>(){

            @Override
            protected void writeContent(CompoundTag content, RegistryFriendlyByteBuf buffer) {
                buffer.writeNbt((Tag)content);
            }

            @Override
            protected CompoundTag readContent(RegistryFriendlyByteBuf buffer) {
                return buffer.readNbt();
            }
        }, CompoundTag.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<ItemStack>(){

            @Override
            protected void writeContent(ItemStack content, RegistryFriendlyByteBuf buffer) {
                FriendlyByteBuf.writeNullable((ByteBuf)buffer, (Object)content, (StreamEncoder)ItemStack.OPTIONAL_STREAM_CODEC);
            }

            @Override
            protected ItemStack readContent(RegistryFriendlyByteBuf buffer) {
                return (ItemStack)FriendlyByteBuf.readNullable((ByteBuf)buffer, (StreamDecoder)ItemStack.OPTIONAL_STREAM_CODEC);
            }
        }, ItemStack.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<ResourceLocation>(){

            @Override
            protected void writeContent(ResourceLocation content, RegistryFriendlyByteBuf buffer) {
                buffer.writeResourceLocation(content);
            }

            @Override
            protected ResourceLocation readContent(RegistryFriendlyByteBuf buffer) {
                return buffer.readResourceLocation();
            }
        }, ResourceLocation.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<BlockState>(){

            @Override
            protected void writeContent(BlockState content, RegistryFriendlyByteBuf buffer) {
                buffer.writeInt(Block.getId((BlockState)content));
            }

            @Override
            protected BlockState readContent(RegistryFriendlyByteBuf buffer) {
                return Block.stateById((int)buffer.readInt());
            }
        }, BlockState.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Block>(){

            @Override
            protected void writeContent(Block content, RegistryFriendlyByteBuf buffer) {
                buffer.writeResourceLocation(BuiltInRegistries.BLOCK.getKey((Object)content));
            }

            @Override
            protected Block readContent(RegistryFriendlyByteBuf buffer) {
                return (Block)BuiltInRegistries.BLOCK.getValue(buffer.readResourceLocation());
            }
        }, Block.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Item>(){

            @Override
            protected void writeContent(Item content, RegistryFriendlyByteBuf buffer) {
                buffer.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)content));
            }

            @Override
            protected Item readContent(RegistryFriendlyByteBuf buffer) {
                return (Item)BuiltInRegistries.ITEM.getValue(buffer.readResourceLocation());
            }
        }, Item.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vector3d>(){

            @Override
            protected void writeContent(Vector3d content, RegistryFriendlyByteBuf buffer) {
                buffer.writeDouble(content.x);
                buffer.writeDouble(content.y);
                buffer.writeDouble(content.z);
            }

            @Override
            protected Vector3d readContent(RegistryFriendlyByteBuf buffer) {
                return new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, Vector3d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec3>(){

            @Override
            protected void writeContent(Vec3 content, RegistryFriendlyByteBuf buffer) {
                buffer.writeDouble(content.x);
                buffer.writeDouble(content.y);
                buffer.writeDouble(content.z);
            }

            @Override
            protected Vec3 readContent(RegistryFriendlyByteBuf buffer) {
                return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, Vec3.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec1d>(){

            @Override
            protected void writeContent(Vec1d content, RegistryFriendlyByteBuf buffer) {
                buffer.writeDouble(content.x);
            }

            @Override
            protected Vec1d readContent(RegistryFriendlyByteBuf buffer) {
                return new Vec1d(buffer.readDouble());
            }
        }, Vec1d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec1f>(){

            @Override
            protected void writeContent(Vec1f content, RegistryFriendlyByteBuf buffer) {
                buffer.writeFloat(content.x);
            }

            @Override
            protected Vec1f readContent(RegistryFriendlyByteBuf buffer) {
                return new Vec1f(buffer.readFloat());
            }
        }, Vec1f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec2d>(){

            @Override
            protected void writeContent(Vec2d content, RegistryFriendlyByteBuf buffer) {
                buffer.writeDouble(content.x);
                buffer.writeDouble(content.y);
            }

            @Override
            protected Vec2d readContent(RegistryFriendlyByteBuf buffer) {
                return new Vec2d(buffer.readDouble(), buffer.readDouble());
            }
        }, Vec2d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec2f>(){

            @Override
            protected void writeContent(Vec2f content, RegistryFriendlyByteBuf buffer) {
                buffer.writeFloat(content.x);
                buffer.writeFloat(content.y);
            }

            @Override
            protected Vec2f readContent(RegistryFriendlyByteBuf buffer) {
                return new Vec2f(buffer.readFloat(), buffer.readFloat());
            }
        }, Vec2f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec3d>(){

            @Override
            protected void writeContent(Vec3d content, RegistryFriendlyByteBuf buffer) {
                buffer.writeDouble(content.x);
                buffer.writeDouble(content.y);
                buffer.writeDouble(content.z);
            }

            @Override
            protected Vec3d readContent(RegistryFriendlyByteBuf buffer) {
                return new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, Vec3d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec3f>(){

            @Override
            protected void writeContent(Vec3f content, RegistryFriendlyByteBuf buffer) {
                buffer.writeFloat(content.x);
                buffer.writeFloat(content.y);
                buffer.writeFloat(content.z);
            }

            @Override
            protected Vec3f readContent(RegistryFriendlyByteBuf buffer) {
                return new Vec3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        }, Vec3f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vector3f>(){

            @Override
            protected void writeContent(Vector3f content, RegistryFriendlyByteBuf buffer) {
                buffer.writeFloat(content.x());
                buffer.writeFloat(content.y());
                buffer.writeFloat(content.z());
            }

            @Override
            protected Vector3f readContent(RegistryFriendlyByteBuf buffer) {
                return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        }, Vector3f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<UUID>(){

            @Override
            protected void writeContent(UUID content, RegistryFriendlyByteBuf buffer) {
                buffer.writeUtf(content.toString());
            }

            @Override
            protected UUID readContent(RegistryFriendlyByteBuf buffer) {
                return UUID.fromString(buffer.readUtf(Short.MAX_VALUE));
            }
        }, UUID.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<JsonObject>(){

            @Override
            protected void writeContent(JsonObject content, RegistryFriendlyByteBuf buffer) {
                buffer.writeUtf(content.toString());
            }

            @Override
            protected JsonObject readContent(RegistryFriendlyByteBuf buffer) {
                return (JsonObject)GSON.fromJson(buffer.readUtf(Short.MAX_VALUE), JsonObject.class);
            }
        }, JsonObject.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Holder>(){

            @Override
            protected void writeContent(Holder content, RegistryFriendlyByteBuf buffer) {
                ResourceKey key = (ResourceKey)content.unwrapKey().get();
                buffer.writeResourceLocation(key.registry());
                buffer.writeResourceLocation(key.location());
            }

            @Override
            protected Holder readContent(RegistryFriendlyByteBuf buffer) {
                ResourceKey key = ResourceKey.create((ResourceKey)buffer.readRegistryKey(), (ResourceLocation)buffer.readResourceLocation());
                Registry l = buffer.registryAccess().lookupOrThrow(key.registryKey());
                return l.getOrThrow(key);
            }
        }, Holder.class);
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial<Object>((x, y) -> x.isArray()){

            @Override
            public void write(Object content, Class classType, Type genericType, CreativeByteBuf buffer, PacketFlow flow) {
                Class<?> subClass = classType.getComponentType();
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, null);
                int length = Array.getLength(content);
                buffer.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(Array.get(content, i), subClass, null, buffer, flow);
                }
            }

            @Override
            public Object read(Class classType, Type genericType, CreativeByteBuf buffer, PacketFlow flow) {
                int length = buffer.readInt();
                Class<?> subClass = classType.getComponentType();
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, null);
                Object object = Array.newInstance(subClass, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(object, i, subParser.read(subClass, null, buffer, flow));
                }
                return object;
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial((x, y) -> x.equals(ArrayList.class) || x.equals(List.class)){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void write(Object content, Class classType, Type genericType, CreativeByteBuf buffer, PacketFlow flow) {
                Type subType;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Class subClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, subType = types[0]);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = ((List)content).size();
                buffer.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(((List)content).get(i), subClass, subType, buffer, flow);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object read(Class classType, Type genericType, CreativeByteBuf buffer, PacketFlow flow) {
                Type subType;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Class subClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, subType = types[0]);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = buffer.readInt();
                ArrayList list = new ArrayList(length);
                for (int j = 0; j < length; ++j) {
                    list.add(subParser.read(subClass, subType, buffer, flow));
                }
                return list;
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial<Object>((x, y) -> x.isEnum()){

            @Override
            public void write(Object content, Class classType, Type genericType, CreativeByteBuf buffer, PacketFlow flow) {
                buffer.writeEnum((Enum)content);
            }

            @Override
            public Object read(Class classType, Type genericType, CreativeByteBuf buffer, PacketFlow flow) {
                return buffer.readEnum(classType);
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Filter>(){

            @Override
            protected void writeContent(Filter content, RegistryFriendlyByteBuf buffer) {
                try {
                    buffer.writeNbt((Tag)Filter.SERIALIZER.write(content));
                }
                catch (RegistryException e) {
                    CreativeCore.LOGGER.error((Object)e);
                }
            }

            @Override
            protected Filter readContent(RegistryFriendlyByteBuf buffer) {
                try {
                    return Filter.SERIALIZER.read((CompoundTag)buffer.readNbt(NbtAccounter.unlimitedHeap()));
                }
                catch (RegistryException e) {
                    CreativeCore.LOGGER.error((Object)e);
                    return Filter.or(new Filter[0]);
                }
            }
        }, Filter.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<BiFilter>(){

            @Override
            protected void writeContent(BiFilter content, RegistryFriendlyByteBuf buffer) {
                try {
                    buffer.writeNbt((Tag)BiFilter.SERIALIZER.write(content));
                }
                catch (RegistryException e) {
                    CreativeCore.LOGGER.error((Object)e);
                }
            }

            @Override
            protected BiFilter readContent(RegistryFriendlyByteBuf buffer) {
                try {
                    return BiFilter.SERIALIZER.read((CompoundTag)buffer.readNbt(NbtAccounter.unlimitedHeap()));
                }
                catch (RegistryException e) {
                    CreativeCore.LOGGER.error((Object)e);
                    return BiFilter.or(new BiFilter[0]);
                }
            }
        }, BiFilter.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Component>(){
            private static final Gson GSON = (Gson)Util.make(() -> {
                GsonBuilder gsonbuilder = new GsonBuilder();
                gsonbuilder.disableHtmlEscaping();
                return gsonbuilder.create();
            });

            @Override
            protected void writeContent(Component content, RegistryFriendlyByteBuf buffer) {
                buffer.writeUtf(GSON.toJson((Object)content));
            }

            @Override
            protected Component readContent(RegistryFriendlyByteBuf buffer) {
                return (Component)GsonHelper.fromJson((Gson)GSON, (String)buffer.readUtf(), MutableComponent.class, (boolean)false);
            }
        }, Component.class);
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial<Tag>((x, y) -> Tag.class.isAssignableFrom((Class<?>)x)){

            @Override
            public void write(Tag content, Class classType, Type genericType, CreativeByteBuf buffer, PacketFlow flow) {
                buffer.writeNbt(content);
            }

            @Override
            public Tag read(Class classType, Type genericType, CreativeByteBuf buffer, PacketFlow flow) {
                return buffer.readNbt(NbtAccounter.unlimitedHeap());
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial<Packet>((x, y) -> Packet.class.isAssignableFrom((Class<?>)x)){

            @Override
            public void write(Packet content, Class classType, Type genericType, CreativeByteBuf buffer, PacketFlow flow) {
                StreamCodec codec = ConnectionUtils.getProtocolInfo(buffer.connection).codec();
                boolean bundle = content instanceof BundlePacket;
                if (bundle) {
                    List packets = CreativeNetworkUtils.flatten(new SingleIterator(content));
                    buffer.writeInt(packets.size());
                    for (Packet packet : packets) {
                        buffer.writeNullable(packet, (StreamEncoder)codec);
                    }
                } else {
                    buffer.writeInt(0);
                    buffer.writeNullable(content, (StreamEncoder)codec);
                }
            }

            @Override
            public Packet read(Class classType, Type genericType, CreativeByteBuf buffer, PacketFlow flow) {
                StreamCodec codec = ConnectionUtils.getProtocolInfo(buffer.connection).codec();
                int size = buffer.readInt();
                if (size == 0) {
                    return (Packet)buffer.readNullable((StreamDecoder)codec);
                }
                ArrayList packets = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    packets.add((Packet)buffer.readNullable((StreamDecoder)codec));
                }
                return new BundlePacketWrapper(packets);
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Class>(){

            @Override
            protected void writeContent(Class content, RegistryFriendlyByteBuf buffer) {
                buffer.writeUtf(content.getName());
            }

            @Override
            protected Class readContent(RegistryFriendlyByteBuf buffer) {
                try {
                    return Class.forName(buffer.readUtf(Short.MAX_VALUE));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        }, Class.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<IntMatrix3c>(){

            @Override
            protected void writeContent(IntMatrix3c content, RegistryFriendlyByteBuf buffer) {
                buffer.writeInt(content.m00());
                buffer.writeInt(content.m01());
                buffer.writeInt(content.m02());
                buffer.writeInt(content.m10());
                buffer.writeInt(content.m11());
                buffer.writeInt(content.m12());
                buffer.writeInt(content.m20());
                buffer.writeInt(content.m21());
                buffer.writeInt(content.m22());
            }

            @Override
            protected IntMatrix3c readContent(RegistryFriendlyByteBuf buffer) {
                return new IntMatrix3(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        }, IntMatrix3c.class, IntMatrix3.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<DataComponentPatch>(){

            @Override
            protected void writeContent(DataComponentPatch content, RegistryFriendlyByteBuf buffer) {
                DataComponentPatch.STREAM_CODEC.encode((Object)buffer, (Object)content);
            }

            @Override
            protected DataComponentPatch readContent(RegistryFriendlyByteBuf buffer) {
                return (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buffer);
            }
        }, DataComponentPatch.class);
    }
}

