/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonInfo;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.client.gui.manager.GuiClientManager;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;

public class GuiClientLayer
extends GuiClientParent<GuiLayer>
implements GuiLayer.GuiLayerDistHandler {
    public static final int MINIMUM_OUTER_SPACING = 10;
    public GuiStyle style;

    public GuiClientLayer(GuiLayer layer) {
        super(layer);
        this.style = GuiStyle.getStyle(((GuiLayer)this.control).name);
    }

    public Iterable<GuiClientManager> managers() {
        return new FunctionIterator<GuiClientManager>(((GuiLayer)this.control).managers(), x -> (GuiClientManager)x.dist);
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.GUI;
    }

    public int getWidth() {
        return this.rect.getWidth();
    }

    public int getHeight() {
        return this.rect.getHeight();
    }

    @Override
    public void reflow() {
        Rect screen = GuiClientLayer.getScreenRect();
        int screenWidth = (int)screen.getWidth() - this.getContentOffset() * 2 - 10;
        int fixedWidth = -1;
        int width = 0;
        if (this.preferred != null) {
            width = fixedWidth = this.preferred.preferredWidth(this, screenWidth);
        }
        if (fixedWidth == -1) {
            width = this.isExpandableX() ? screenWidth : Math.min(screenWidth, this.preferredWidth(screenWidth));
        }
        if (this.preferred != null) {
            int maxWidth;
            int minWidth = this.preferred.minWidth(this, screenWidth);
            if (minWidth != -1) {
                width = Math.max(width, minWidth);
            }
            if ((maxWidth = this.preferred.maxWidth(this, screenWidth)) != -1) {
                width = Math.min(width, maxWidth);
            }
        }
        this.rect.setRight(width + this.getContentOffset() * 2);
        this.flowX(width, this.preferredWidth(fixedWidth != -1 ? fixedWidth : screenWidth));
        int screenHeight = (int)screen.getHeight() - this.getContentOffset() * 2 - 10;
        int fixedHeight = -1;
        int height = 0;
        if (this.preferred != null) {
            height = fixedHeight = this.preferred.preferredHeight(this, width, screenHeight);
        }
        if (fixedHeight == -1) {
            height = this.isExpandableY() ? screenHeight : Math.min(screenHeight, this.preferredHeight(width, screenHeight));
        }
        if (this.preferred != null) {
            int maxHeight;
            int minHeight = this.preferred.minHeight(this, width, screenHeight);
            if (minHeight != -1) {
                height = Math.max(height, minHeight);
            }
            if ((maxHeight = this.preferred.maxHeight(this, width, screenHeight)) != -1) {
                height = Math.min(height, maxHeight);
            }
        }
        this.rect.setBottom(height + this.getContentOffset() * 2);
        this.flowY(width, height, this.preferredHeight(width, fixedHeight != -1 ? fixedHeight : screenHeight));
    }

    @Override
    public GuiStyle getStyle() {
        return this.style;
    }

    @Override
    protected void renderContent(GuiGraphics graphics, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        super.renderContent(graphics, controlRect, realRect, scale, mouseX, mouseY);
        for (GuiClientManager manager : this.managers()) {
            manager.renderOverlay(graphics, this, mouseX - (int)controlRect.minX, mouseY - (int)controlRect.minY);
        }
    }

    @Override
    protected void renderContent(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public Options getSettings() {
        return Minecraft.getInstance().options;
    }

    public boolean hasGrayBackground() {
        return true;
    }

    @Override
    public boolean mouseClicked(double x, double y, MouseButtonInfo info) {
        if (!this.rect.inside(x, y) && !this.isMouseOverHovered(x, y)) {
            this.looseFocus();
            for (GuiClientManager manager : this.managers()) {
                manager.mouseClickedOutside(x, y);
            }
            return false;
        }
        return super.mouseClicked(x, y, info);
    }

    @Override
    public void mouseReleased(double x, double y, MouseButtonInfo info) {
        super.mouseReleased(x, y, info);
        for (GuiClientManager manager : this.managers()) {
            manager.mouseReleased(x, y, info);
        }
    }

    @Override
    public boolean keyPressed(KeyEvent key) {
        if (key.key() == 256) {
            if (((GuiLayer)this.control).closeLayerUsingEscape()) {
                ((GuiLayer)this.control).closeTopLayer();
            }
            return true;
        }
        if (super.keyPressed(key)) {
            return true;
        }
        if (this.getSettings().keyInventory.matches(key)) {
            ((GuiLayer)this.control).closeTopLayer();
            return true;
        }
        return false;
    }

    @Override
    public void applyOffset(GuiControl control, Rect rect) {
        rect.move((double)((GuiClientControl)control.dist()).rect.getX() + this.getOffsetX(), (double)((GuiClientControl)control.dist()).rect.getY() + this.getOffsetY());
        rect.scale(this.scaleFactor());
    }
}

