/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.parent;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;

public class GuiClientScrollY<T extends GuiScrollY>
extends GuiClientParent<T>
implements GuiScrollY.GuiScrollYDist {
    public int maxScroll = 0;
    public SmoothValue scrolled = new SmoothValue(200L);
    public boolean dragged;
    public int scrollbarWidth = 3;
    public boolean hoveredScroll;
    protected int cachedHeight;
    private boolean scrollWhenCTRL;

    public GuiClientScrollY(T control) {
        super(control);
    }

    @Override
    public void setScrollWhenCTRL() {
        this.scrollWhenCTRL = true;
    }

    @Override
    public void setHovered() {
        this.hoveredScroll = true;
    }

    @Override
    public void setHover(boolean hover) {
        this.hoveredScroll = hover;
    }

    @Override
    public double getOffsetY() {
        return -this.scrolled.current();
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.NESTED;
    }

    public void onScrolled() {
        if (this.scrolled.aimed() < 0.0) {
            this.scrolled.set(0.0);
        }
        if (this.scrolled.aimed() > (double)this.maxScroll) {
            this.scrolled.set(this.maxScroll);
        }
    }

    @Override
    public boolean mouseScrolled(double x, double y, double scrolled) {
        if (super.mouseScrolled(x, y, scrolled)) {
            return true;
        }
        this.scroll(scrolled);
        return true;
    }

    public void scroll(double scrolled) {
        if (!this.scrollWhenCTRL || Minecraft.getInstance().hasControlDown()) {
            this.scrolled.set(this.scrolled.aimed() - scrolled * 10.0);
            this.onScrolled();
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, MouseButtonInfo info) {
        if (info.button() == 0 && (double)this.rect.getWidth() - x <= (double)this.scrollbarWidth && this.needsScrollbar()) {
            this.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
            this.dragged = true;
            return true;
        }
        return super.mouseClicked(x, y, info);
    }

    @Override
    public void mouseMoved(double x, double y) {
        if (this.dragged) {
            GuiStyle style = this.getStyle();
            ControlFormatting formatting = this.getControlFormatting();
            int completeHeight = this.rect.getHeight() - style.getBorder(formatting.border()) * 2;
            int scrollThingHeight = Math.max(10, Math.min(completeHeight, (int)((float)completeHeight / (float)this.cachedHeight * (float)completeHeight)));
            if (this.cachedHeight < completeHeight) {
                scrollThingHeight = completeHeight;
            }
            double percent = y / (double)(completeHeight - scrollThingHeight);
            this.scrolled.set((int)(percent * (double)this.maxScroll));
            this.onScrolled();
        }
        super.mouseMoved(x, y);
    }

    @Override
    public void mouseReleased(double x, double y, MouseButtonInfo info) {
        super.mouseReleased(x, y, info);
        this.dragged = false;
    }

    public boolean needsScrollbar() {
        return this.cachedHeight > this.rect.getContentHeight();
    }

    @Override
    protected void renderContent(GuiGraphics graphics, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        Matrix3x2fStack pose = graphics.pose();
        pose.pushMatrix();
        super.renderContent(graphics, formatting, borderWidth, controlRect, realRect, scale, mouseX, mouseY);
        pose.popMatrix();
        if (!this.needsScrollbar() && this.hoveredScroll) {
            return;
        }
        float controlInvScale = (float)this.scaleFactorInv();
        pose.scale(controlInvScale, controlInvScale);
        GuiClientScrollY.scissor(graphics, realRect);
        GuiStyle style = this.getStyle();
        this.scrolled.tick();
        int completeHeight = this.rect.getHeight() - borderWidth * 2;
        int scrollThingHeight = Math.max(10, Math.min(completeHeight, (int)((float)completeHeight / (float)this.cachedHeight * (float)completeHeight)));
        if (this.cachedHeight < completeHeight) {
            scrollThingHeight = completeHeight;
        }
        double percent = this.scrolled.current() / (double)this.maxScroll;
        StyleDisplay display = this.hoveredScroll ? style.disabled : style.get(ControlFormatting.ControlStyleFace.CLICKABLE, false);
        display.render(graphics, this.rect.getWidth() - this.scrollbarWidth - borderWidth, (int)(percent * (double)(completeHeight - scrollThingHeight)) + borderWidth, this.scrollbarWidth, scrollThingHeight);
        this.maxScroll = Math.max(0, this.cachedHeight - completeHeight + formatting.padding() * 2 + 1);
        float controlScale = (float)this.scaleFactor();
        pose.scale(controlScale, controlScale);
    }

    @Override
    protected int minWidth(int availableWidth) {
        return 10;
    }

    @Override
    protected int minHeight(int width, int availableHeight) {
        return 10;
    }

    @Override
    public void flowX(int width, int preferred) {
        if (!this.hoveredScroll) {
            width -= this.scrollbarWidth;
        }
        super.flowX(width, preferred);
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        super.flowY(width, height, preferred);
        this.cachedHeight = preferred;
    }

    @Override
    protected boolean endlessY() {
        return true;
    }
}

