/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.tree;

import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiClientTreeItem<T extends GuiTreeItem>
extends GuiClientParent<T> {
    private ItemClickState state = null;

    public GuiClientTreeItem(T control) {
        super(control);
    }

    @Override
    public void mouseMoved(double x, double y) {
        super.mouseMoved(x, y);
        if (this.state == ItemClickState.CLICKED && !((GuiTreeItem)this.control).tree.isDragged() && !this.rect.inside(x, y)) {
            ((GuiTreeItem)this.control).tree.startDrag((GuiTreeItem)this.control);
            this.state = ItemClickState.DRAGGED;
        }
    }

    @Override
    public void mouseReleased(double x, double y, MouseButtonInfo info) {
        super.mouseReleased(x, y, info);
        if (this.state == ItemClickState.CLICKED) {
            ((GuiTreeItem)this.control).tree.select((GuiTreeItem)this.control);
            this.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
            this.state = null;
        } else if (this.state == ItemClickState.DRAGGED) {
            this.state = null;
            if (((GuiTreeItem)this.control).tree.endDrag()) {
                this.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 0.1f, 2.0f);
            }
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, MouseButtonInfo info) {
        if (super.mouseClicked(x, y, info)) {
            return true;
        }
        this.state = ItemClickState.CLICKED;
        return true;
    }

    @Override
    public boolean mouseDoubleClicked(double x, double y, MouseButtonInfo info) {
        ((GuiTreeItem)this.control).toggle();
        ((GuiTreeItem)this.control).tree.select((GuiTreeItem)this.control);
        this.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
        return true;
    }

    @Override
    public boolean testForDoubleClick(double x, double y, MouseButtonInfo info) {
        return info.button() == 0;
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        if (this.state == ItemClickState.DRAGGED) {
            return ControlFormatting.OUTLINE;
        }
        return super.getControlFormatting();
    }

    private static enum ItemClickState {
        CLICKED,
        DRAGGED;

    }
}

