/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.integration;

import com.mojang.blaze3d.Blaze3D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import team.creative.creativecore.client.gui.GuiClientLayer;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.mixin.MouseHandlerAccessor;

public class ScreenEventListener
implements GuiEventListener,
NarratableEntry {
    public static final double DOUBLE_CLICK_TIME = 0.2;
    private final IGuiIntegratedParent gui;
    private final Screen screen;
    private MouseButtonInfo doubleClickButton = null;
    private double time;
    private double x;
    private double y;
    private boolean released = false;
    private boolean focused;

    public ScreenEventListener(IGuiIntegratedParent gui, Screen screen) {
        this.gui = gui;
        this.screen = screen;
    }

    public GuiClientLayer getTopLayer() {
        return (GuiClientLayer)this.gui.getTopLayer().dist();
    }

    public int getOffsetX() {
        return (this.screen.width - this.getTopLayer().getWidth()) / 2;
    }

    public int getOffsetY() {
        return (this.screen.height - this.getTopLayer().getHeight()) / 2;
    }

    public void tick() {
        if (this.doubleClickButton != null && Blaze3D.getTime() - this.time > 0.2) {
            this.fireRemaingEvents();
        }
    }

    public double getEventTime() {
        return ((MouseHandlerAccessor)Minecraft.getInstance().mouseHandler).getLastHandleMovementTime();
    }

    protected void fireRemaingEvents() {
        if (this.doubleClickButton != null) {
            this.getTopLayer().mouseClicked(this.x, this.y, this.doubleClickButton);
            if (this.released) {
                this.getTopLayer().mouseReleased(this.x, this.y, this.doubleClickButton);
            }
            this.doubleClickButton = null;
            this.released = false;
        }
    }

    public void mouseMoved(double x, double y) {
        this.getTopLayer().mouseMoved(x - (double)this.getOffsetX(), y - (double)this.getOffsetY());
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.getTopLayer().testForDoubleClick(event.x() - (double)this.getOffsetX(), event.y() - (double)this.getOffsetY(), event.buttonInfo())) {
            if (this.doubleClickButton.equals((Object)event)) {
                this.released = false;
                this.doubleClickButton = null;
                return this.getTopLayer().mouseDoubleClicked(event.x() - (double)this.getOffsetX(), event.y() - (double)this.getOffsetY(), event.buttonInfo());
            }
            this.fireRemaingEvents();
            this.doubleClickButton = event.buttonInfo();
            this.time = this.getEventTime();
            this.x -= (double)this.getOffsetX();
            this.y -= (double)this.getOffsetY();
            return true;
        }
        this.fireRemaingEvents();
        return this.getTopLayer().mouseClicked(event.x() - (double)this.getOffsetX(), event.y() - (double)this.getOffsetY(), event.buttonInfo());
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.doubleClickButton == event.buttonInfo()) {
            this.released = true;
            return true;
        }
        this.fireRemaingEvents();
        this.getTopLayer().mouseReleased(event.x() - (double)this.getOffsetX(), event.y() - (double)this.getOffsetY(), event.buttonInfo());
        return true;
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        if (this.doubleClickButton == null) {
            this.getTopLayer().mouseDragged(event.x() - (double)this.getOffsetX(), event.y() - (double)this.getOffsetY(), event.buttonInfo(), dragX, dragY, Blaze3D.getTime() - this.time);
        }
        return true;
    }

    public boolean mouseScrolled(double x, double y, double deltaX, double deltaY) {
        return this.getTopLayer().mouseScrolled(x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), deltaY);
    }

    public boolean keyPressed(KeyEvent key) {
        return this.getTopLayer().keyPressed(key);
    }

    public boolean keyReleased(KeyEvent key) {
        return this.getTopLayer().keyReleased(key);
    }

    public boolean charTyped(CharacterEvent event) {
        return this.getTopLayer().charTyped(event);
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return true;
    }

    public void updateNarration(NarrationElementOutput p_169152_) {
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }
}

