/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.premade.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;

public class RegistryObjectListConfig<T>
implements Iterable<T> {
    public final Registry<T> registry;
    private final List<RegistryHolder> content = new ArrayList<RegistryHolder>();

    public RegistryObjectListConfig(Registry<T> registry) {
        this.registry = registry;
    }

    public void add(Identifier identifier) {
        if (!this.contains(identifier)) {
            this.content.add(new RegistryHolder(identifier));
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new FunctionIterator<Object>(this.content, x -> x.get());
    }

    public Iterable<Identifier> identifiers() {
        return new FunctionIterator<Identifier>(this.content, x -> x.identifier);
    }

    public boolean contains(Identifier location) {
        for (int i = 0; i < this.content.size(); ++i) {
            if (!this.content.get((int)i).identifier.equals((Object)location)) continue;
            return true;
        }
        return false;
    }

    public Identifier getLocation(int index) {
        return this.content.get((int)index).identifier;
    }

    public int size() {
        return this.content.size();
    }

    public class RegistryHolder {
        public final Identifier identifier;
        private T cache;

        public RegistryHolder(Identifier identifier) {
            this.identifier = identifier;
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RegistryHolder) {
                RegistryHolder h = (RegistryHolder)obj;
                return h.identifier.equals((Object)this.identifier);
            }
            return super.equals(obj);
        }

        public T get() {
            if (this.cache == null) {
                this.cache = RegistryObjectListConfig.this.registry.getValue(this.identifier);
            }
            return this.cache;
        }
    }
}

