/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.manager;

import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.CreativeCoreGuiRegistry;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.manager.GuiManager;

public class GuiManagerItem
extends GuiManager {
    private ItemStack hand = ItemStack.EMPTY;
    private boolean handChanged;
    public SlotAccess handAccess = new SlotAccess(){

        public ItemStack get() {
            return GuiManagerItem.this.getHand();
        }

        public boolean set(ItemStack hand) {
            GuiManagerItem.this.setHand(hand);
            return true;
        }
    };

    public GuiManagerItem(GuiLayer layer) {
        super(layer);
    }

    @Override
    public void tick() {
        if (this.handChanged) {
            this.handChanged = false;
            if (!this.layer.isClient()) {
                CreativeCoreGuiRegistry.HAND.send(this.layer, (CompoundTag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.hand).getOrThrow());
            }
        }
        super.tick();
    }

    @Override
    public void closed() {
        if (!(this.layer.isClient() || this.hand.isEmpty() || this.layer.getPlayer().addItem(this.hand))) {
            this.layer.getPlayer().drop(this.hand, false);
        }
        super.closed();
    }

    public ItemStack getHand() {
        return this.hand;
    }

    public void setHandChanged() {
        this.handChanged = true;
    }

    public void setHand(ItemStack stack) {
        this.hand = stack;
        this.setHandChanged();
    }
}

