/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import team.creative.creativecore.common.network.CreativeByteBuf;
import team.creative.creativecore.common.network.CreativeNetworkField;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetworkPacket<T extends CreativePacket> {
    public final CustomPacketPayload.Type<T> sid;
    public final CustomPacketPayload.Type<T> cid;
    public final Class<T> classType;
    public final Supplier<T> supplier;
    public List<CreativeNetworkField> parsers = new ArrayList<CreativeNetworkField>();
    public final boolean fabric;

    public CreativeNetworkPacket(Identifier id, Class<T> classType, Supplier<T> supplier, boolean fabric) {
        this.sid = new CustomPacketPayload.Type(Identifier.tryBuild((String)id.getNamespace(), (String)(id.getPath() + "s")));
        this.cid = new CustomPacketPayload.Type(Identifier.tryBuild((String)id.getNamespace(), (String)(id.getPath() + "c")));
        this.classType = classType;
        this.supplier = supplier;
        this.fabric = fabric;
        for (Field field : this.classType.getFields()) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            CreativeNetworkField parser = CreativeNetworkField.create(field);
            if (parser != null) {
                this.parsers.add(parser);
                continue;
            }
            throw new RuntimeException("Could not find parser for " + classType.getName() + "." + field.getName() + "! type: " + field.getType().getName());
        }
    }

    public void write(T packet, CreativeByteBuf buffer, PacketFlow flow) {
        for (CreativeNetworkField parser : this.parsers) {
            parser.write((CreativePacket)packet, buffer, flow);
        }
    }

    public T read(CreativeByteBuf buffer, PacketFlow flow) {
        CreativePacket message = (CreativePacket)this.supplier.get();
        for (CreativeNetworkField parser : this.parsers) {
            parser.read(message, buffer, flow);
        }
        message.setType(!this.fabric && flow == PacketFlow.CLIENTBOUND ? this.cid : this.sid);
        return (T)message;
    }
}

