/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;

public class CreativeIngredientBlock
extends CreativeIngredient {
    public Block block;

    public CreativeIngredientBlock(Block block) {
        this.block = block;
    }

    public CreativeIngredientBlock() {
    }

    @Override
    protected void loadExtra(HolderLookup.Provider provider, CompoundTag nbt) {
        this.block = (Block)((HolderLookup.RegistryLookup)provider.lookup(Registries.BLOCK).get()).get(ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier.parse((String)nbt.getStringOr("block", "")))).orElse(Blocks.AIR.builtInRegistryHolder()).value();
    }

    @Override
    protected void saveExtra(HolderLookup.Provider provider, CompoundTag nbt) {
        nbt.putString("block", this.block.builtInRegistryHolder().getRegisteredName());
    }

    @Override
    public boolean is(CreativeIngredient info) {
        if (info instanceof CreativeIngredientBlock) {
            return ((CreativeIngredientBlock)info).block == this.block;
        }
        if (info instanceof CreativeIngredientItemStack) {
            return this.block == Block.byItem((Item)((CreativeIngredientItemStack)info).stack.getItem());
        }
        return false;
    }

    @Override
    public boolean is(Level level, ItemStack stack) {
        return Block.byItem((Item)stack.getItem()) == this.block;
    }

    @Override
    public boolean equals(CreativeIngredient object) {
        return object instanceof CreativeIngredientBlock && ((CreativeIngredientBlock)object).block == this.block;
    }

    @Override
    public ItemStack getExample() {
        return new ItemStack((ItemLike)this.block);
    }

    @Override
    public CreativeIngredient copy() {
        return new CreativeIngredientBlock(this.block);
    }

    @Override
    public Component description() {
        return this.block.getName();
    }

    @Override
    public Component descriptionDetail() {
        return Component.translatable((String)"minecraft.block").append(": " + String.valueOf(ChatFormatting.YELLOW) + this.block.builtInRegistryHolder().getRegisteredName());
    }
}

