package team.creative.creativecore.common.gui.control.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;

public class GuiListBoxBase<T extends GuiControl> extends GuiScrollY {
    
    protected List<GuiRow> rows = new ArrayList<>();
    protected List<T> content;
    
    public final boolean modifiable;
    
    public Predicate<T> canBeModified = x -> true;
    
    public GuiListBoxBase(String name, boolean modifiable, List<T> entries) {
        super(name);
        this.content = entries;
        this.modifiable = modifiable;
        createItems();
    }
    
    protected void createItems() {
        for (int i = 0; i < content.size(); i++)
            createControl(i);
    }
    
    protected void createControl(int index) {
        GuiRow row = new GuiRow();
        super.add(row);
        GuiColumn content = (GuiColumn) new GuiColumn().setExpandableX();
        content.align = Align.CENTER;
        content.add(this.content.get(index));
        row.addColumn(content);
        if (modifiable && canBeModified.test(this.content.get(index))) {
            GuiColumn remove = new GuiColumn(20);
            remove.align = Align.CENTER;
            remove.add(new GuiButtonRemove(index));
            row.addColumn(remove);
        }
        rows.add(row);
    }
    
    protected void removeControl(int index) {
        remove(rows.get(index));
        rows.remove(index);
        content.remove(index);
    }
    
    protected GuiControl addCustomControl(GuiControl control) {
        return super.add(control);
    }
    
    protected GuiListBoxBase addCustom(GuiControl control) {
        super.add(control);
        return this;
    }
    
    @Override
    @Deprecated
    public GuiParent add(GuiControl control) {
        throw new UnsupportedOperationException();
    }
    
    @Override
    @Deprecated
    public GuiParent addHover(GuiControl control) {
        throw new UnsupportedOperationException();
    }
    
    @Override
    public void flowY(int width, int height, int preferred) {
        this.cachedHeight = height;
        super.flowY(width, height, preferred);
    }
    
    public void reflowInternal() {
        if (hasGui()) {
            super.flowX(rect.getContentWidth(), preferredWidth(rect.getContentWidth()));
            super.flowY(rect.getContentWidth(), cachedHeight, preferredHeight(rect.getContentWidth(), cachedHeight));
        }
    }
    
    public void removeItem(int index) {
        removeControl(index);
        
        if (modifiable)
            for (int i = 0; i < rows.size(); i++)
                if (canBeModified.test(this.content.get(i)))
                    ((GuiButtonRemove) rows.get(i).getCol(1).get("x")).index = i;
        reflowInternal();
        raiseEvent(new GuiControlChangedEvent(this));
    }
    
    public void clearItems() {
        while (!content.isEmpty())
            removeControl(content.size() - 1);
    }
    
    public void addAllItems(List<T> entries) {
        for (T entry : entries) {
            content.add(entry);
            createControl(content.size() - 1);
        }
        
        reflowInternal();
    }
    
    public void addItem(T entry) {
        content.add(entry);
        createControl(content.size() - 1);
        
        reflowInternal();
        
        raiseEvent(new GuiControlChangedEvent(this));
    }
    
    @Override
    public boolean isEmpty() {
        return content.isEmpty();
    }
    
    @Override
    public int size() {
        return content.size();
    }
    
    public T get(int index) {
        return content.get(index);
    }
    
    public Iterable<T> items() {
        return content;
    }
    
    public class GuiButtonRemove extends GuiButton {
        
        public int index;
        
        public GuiButtonRemove(int index) {
            super("x", null);
            setDim(6, 8);
            setAlign(Align.CENTER);
            setTitle(Component.literal("x"));
            pressed = (x) -> GuiListBoxBase.this.removeItem(this.index);
            this.index = index;
        }
        
    }
    
}
