package team.creative.creativecore;

import java.util.function.Consumer;
import java.util.function.Supplier;

import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.Event;
import team.creative.creativecore.client.ClientLoader;
import team.creative.creativecore.common.CommonLoader;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;

public interface ICreativeLoader {
    
    public default void loadCommon() {
        CreativeCoreGuiRegistry.init();
        GuiDialogHandler.init();
    }
    
    public Side getOverallSide();
    
    public Side getEffectiveSide();
    
    public void register(CommonLoader loader);
    
    public void registerClient(ClientLoader loader);
    
    public void registerClientTick(Runnable run);
    
    public void registerClientRenderStart(Runnable run);
    
    public void registerClientRenderGui(Consumer run);
    
    public void registerClientStarted(Runnable run);
    
    public void registerReloadListener(ResourceLocation location, PreparableReloadListener listener);
    
    public void registerKeybind(Supplier<KeyMapping> supplier);
    
    public void registerLevelTick(Consumer<ServerLevel> consumer);
    
    public void registerLevelTickStart(Consumer<ServerLevel> consumer);
    
    public void registerLoadLevel(Consumer<LevelAccessor> consumer);
    
    public void registerUnloadLevel(Consumer<LevelAccessor> consumer);
    
    public <T> void registerListener(Consumer<T> consumer);
    
    public float getFluidViscosityMultiplier(Fluid fluid, Level level);
    
    public float getFriction(LevelAccessor level, BlockPos pos, Entity entity);
    
    public void postForge(Event event);
    
    public boolean isModLoaded(String modid);
    
}
