/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.inventory;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.render.gui.CreativeGuiGraphics;
import team.creative.creativecore.common.gui.control.inventory.GuiSlotBase;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.util.math.geo.Rect;

public abstract class GuiClientSlotBase<T extends GuiSlotBase>
extends GuiClientControl<T> {
    public static final int SLOT_SIZE = 18;
    public static final DisplayColor HOVER = new DisplayColor(1.0f, 1.0f, 1.0f, 0.3f);
    private boolean hovered;

    public GuiClientSlotBase(T control) {
        super(control);
    }

    protected abstract ItemStack getStackToRender();

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.SLOT;
    }

    @Override
    public List<Component> getTooltip() {
        if (((GuiSlotBase)this.control).getStack().isEmpty()) {
            return super.getTooltip();
        }
        return ((GuiSlotBase)this.control).getStack().getTooltipLines(Item.TooltipContext.of((HolderLookup.Provider)((GuiSlotBase)this.control).provider()), ((GuiSlotBase)this.control).getPlayer(), (TooltipFlag)TooltipFlag.Default.NORMAL);
    }

    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    protected void renderContent(GuiGraphics graphics, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        Matrix3x2fStack pose = graphics.pose();
        pose.translate(1.0f, 1.0f);
        ItemStack stack = this.getStackToRender();
        graphics.renderItem(stack, 0, 0);
        ((CreativeGuiGraphics)graphics).renderItemDecorations(stack, 0, 0);
        pose.translate(-1.0f, -1.0f);
        if (realRect.inside(mouseX, mouseY) && this.enabled) {
            HOVER.render(graphics, this.rect.getWidth(), this.rect.getHeight());
            this.hovered = true;
        } else {
            this.hovered = false;
        }
    }

    @Override
    protected void renderContent(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    @Override
    public boolean mouseClicked(double x, double y, MouseButtonInfo info) {
        return true;
    }

    @Override
    public void flowX(int width, int preferred) {
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int maxWidth(int availableWidth) {
        return 18;
    }

    @Override
    protected int maxHeight(int width, int availableHeight) {
        return 18;
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 18;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 18;
    }

    @Override
    protected int minWidth(int availableWidth) {
        return 18;
    }

    @Override
    protected int minHeight(int width, int availableHeight) {
        return 18;
    }
}

