/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.simple;

import net.minecraft.client.input.MouseButtonInfo;
import team.creative.creativecore.client.gui.control.simple.GuiClientButton;
import team.creative.creativecore.common.gui.control.simple.GuiButtonHold;

public class GuiClientButtonHold<T extends GuiButtonHold>
extends GuiClientButton<T>
implements GuiButtonHold.GuiButtonHoldDist {
    public static final int INITIAL_WAIT = 250;
    public static final int CONTINOUS_WAIT = 100;
    public int clicked = -1;
    public boolean inital = false;
    public long wait = 0L;

    public GuiClientButtonHold(T control) {
        super(control);
    }

    @Override
    public boolean mouseClicked(double x, double y, MouseButtonInfo info) {
        this.wait = System.currentTimeMillis();
        this.clicked = info.button();
        this.inital = true;
        return super.mouseClicked(x, y, info);
    }

    @Override
    public void mouseReleased(double x, double y, MouseButtonInfo info) {
        this.clicked = -1;
        super.mouseReleased(x, y, info);
    }

    @Override
    public void tick() {
        if (this.clicked != -1) {
            if (this.inital) {
                if (System.currentTimeMillis() - this.wait >= 250L) {
                    this.pressed.accept(this.clicked);
                    this.wait = System.currentTimeMillis();
                    this.inital = false;
                }
            } else if (System.currentTimeMillis() - this.wait >= 100L) {
                this.pressed.accept(this.clicked);
                this.wait = System.currentTimeMillis();
            }
        }
    }

    @Override
    public void mouseMoved(double x, double y) {
        if (this.clicked != -1 && !this.rect.inside(x, y)) {
            this.wait = System.currentTimeMillis();
        }
        super.mouseMoved(x, y);
    }
}

