/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.collection;

import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.util.mc.StackUtils;
import team.creative.creativecore.common.util.type.map.HashMapList;

public class GuiStackSelector
extends GuiLabel {
    public GuiStackSelector(IGuiParent parent, String name, StackCollector collector, boolean searchbar) {
        super(parent, name);
        if (this.dist() != null) {
            this.dist().setSearchbar(searchbar);
            this.dist().setCollector(collector);
            this.dist().updateCollectedStacks(false);
            this.dist().selectFirst(false);
        }
        this.setAlign(Align.CENTER);
    }

    public GuiStackSelector(IGuiParent parent, String name, StackCollector collector) {
        this(parent, name, collector, true);
    }

    @Override
    public GuiStackSelectorDist dist() {
        return (GuiStackSelectorDist)super.dist();
    }

    public GuiStackSelector setWidth(int width) {
        this.setDim(width, 14);
        return this;
    }

    public boolean hasSearchbar() {
        if (this.dist() != null) {
            return this.dist().hasSearchbar();
        }
        return false;
    }

    public GuiStackSelector setSearchbar(boolean searchbar) {
        if (this.dist() != null) {
            this.dist().setSearchbar(searchbar);
        }
        return this;
    }

    public boolean selectFirst() {
        if (this.dist() != null) {
            return this.dist().selectFirst(true);
        }
        return false;
    }

    public void updateCollectedStacks() {
        if (this.dist() != null) {
            this.dist().updateCollectedStacks(true);
        }
    }

    public boolean setSelectedForce(ItemStack stack) {
        if (this.dist() != null) {
            return this.dist().setSelectedForce(stack, true);
        }
        return false;
    }

    public boolean setSelected(ItemStack stack) {
        if (this.dist() != null) {
            return this.dist().setSelected(stack, true);
        }
        return false;
    }

    public HashMapList<String, ItemStack> getStacks() {
        if (this.dist() != null) {
            return this.dist().getStacks();
        }
        return null;
    }

    public ItemStack getSelected() {
        if (this.dist() != null) {
            return this.dist().getSelected();
        }
        return ItemStack.EMPTY;
    }

    public static boolean contains(String search, ItemStack stack) {
        if (search.isEmpty()) {
            return true;
        }
        if (GuiStackSelector.getItemName(stack).toLowerCase().contains(search)) {
            return true;
        }
        for (Component line : stack.getTooltipLines(Item.TooltipContext.EMPTY, null, (TooltipFlag)TooltipFlag.Default.NORMAL)) {
            if (!line.getString().toLowerCase().contains(search)) continue;
            return true;
        }
        return false;
    }

    public static String getItemName(ItemStack stack) {
        String itemName = "";
        try {
            itemName = stack.getDisplayName().getString();
        }
        catch (Exception e) {
            itemName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        }
        return itemName;
    }

    public static interface GuiStackSelectorDist
    extends GuiLabel.GuiLabelDist {
        public void setCollector(StackCollector var1);

        public boolean hasSearchbar();

        public void setSearchbar(boolean var1);

        public boolean selectFirst(boolean var1);

        public void updateCollectedStacks(boolean var1);

        public boolean setSelectedForce(ItemStack var1, boolean var2);

        public boolean setSelected(ItemStack var1, boolean var2);

        public HashMapList<String, ItemStack> getStacks();

        public ItemStack getSelected();
    }

    public static abstract class StackCollector {
        public StackSelector selector;

        public StackCollector(StackSelector selector) {
            this.selector = selector;
        }

        public abstract HashMapList<String, ItemStack> collect(Player var1);
    }

    public static class GuiBlockSelector
    extends SearchSelector {
        @Override
        public boolean allow(ItemStack stack) {
            if (super.allow(stack)) {
                return !(Block.byItem((Item)stack.getItem()) instanceof AirBlock);
            }
            return false;
        }
    }

    public static class SearchSelector
    extends StackSelector {
        public String search = "";

        @Override
        public boolean allow(ItemStack stack) {
            return GuiStackSelector.contains(this.search, stack);
        }
    }

    public static abstract class StackSelector {
        public abstract boolean allow(ItemStack var1);
    }

    public static class CreativeCollector
    extends InventoryCollector {
        public CreativeCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, ItemStack> collect(Player player) {
            HashMapList<String, ItemStack> stacks = super.collect(player);
            ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
            for (Item item : BuiltInRegistries.ITEM) {
                ItemStack stack = new ItemStack((ItemLike)item);
                if (!this.selector.allow(stack)) continue;
                newStacks.add(stack);
            }
            stacks.add("collector.all", (ItemStack)newStacks);
            return stacks;
        }
    }

    public static class InventoryCollector
    extends StackCollector {
        public InventoryCollector(StackSelector selector) {
            super(selector);
        }

        @Override
        public HashMapList<String, ItemStack> collect(Player player) {
            HashMapList<String, ItemStack> stacks = new HashMapList<String, ItemStack>();
            if (player != null) {
                ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>();
                for (ItemStack stack : player.inventoryMenu.getItems()) {
                    if (!stack.isEmpty() && this.selector.allow(stack)) {
                        tempStacks.add(stack.copy());
                        continue;
                    }
                    StackUtils.collect(stack, this.selector::allow, tempStacks);
                }
                stacks.add("collector.inventory", (ItemStack)tempStacks);
            }
            return stacks;
        }
    }
}

