/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.GuiControlDistHandler;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.inventory.GuiSlotBase;
import team.creative.creativecore.common.gui.control.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;

public class GuiSlot
extends GuiSlotBase {
    public final Slot slot;
    private ItemStack lastSend = null;
    private boolean changed = false;

    public GuiSlot(IGuiParent parent, Container container, int index) {
        this(parent, "", container, index);
    }

    public GuiSlot(IGuiParent parent, String name, Container container, int index) {
        this(parent, name + index, new Slot(container, index, 0, 0));
    }

    public GuiSlot(IGuiParent parent, Slot slot) {
        this(parent, "" + slot.getContainerSlot(), slot);
    }

    public GuiSlot(IGuiParent parent, String name, Slot slot) {
        super(parent, name);
        this.slot = slot;
    }

    @Override
    public GuiSlotDist dist() {
        return (GuiSlotDist)super.dist();
    }

    @Override
    public ItemStack getStack() {
        return this.slot.getItem();
    }

    public GuiManagerItem itemManager() {
        return this.getLayer().itemManager();
    }

    public IGuiInventory inventory() {
        IGuiParent parent = this.getParent();
        while (!(parent instanceof IGuiInventory)) {
            if (parent instanceof GuiParent) {
                parent = ((GuiParent)parent).getParent();
                continue;
            }
            throw new RuntimeException("Slot needs inventory parent");
        }
        return (IGuiInventory)((Object)parent);
    }

    @Override
    public void tick() {
        super.tick();
        if (!(this.changed || this.lastSend != null && ItemStack.matches((ItemStack)this.slot.getItem(), (ItemStack)this.lastSend))) {
            this.changed();
        }
    }

    public void onSendUpdate() {
        this.changed = false;
        this.lastSend = this.slot.getItem().copy();
    }

    public void changed() {
        this.changed = true;
        this.inventory().setChanged(this.slot.getContainerSlot());
        if (this.dist() != null) {
            this.dist().changed();
        }
    }

    public ItemStack insert(ItemStack stack) {
        boolean canStack = AbstractContainerMenu.canItemQuickReplace((Slot)this.slot, (ItemStack)stack, (boolean)true);
        int availableStackSize = this.slot.getMaxStackSize(stack);
        if (canStack && this.slot.mayPlace(stack)) {
            int additionalStackSize;
            int neededStackSize = stack.getCount();
            if (this.slot.hasItem()) {
                availableStackSize -= this.slot.getItem().getCount();
            }
            if ((additionalStackSize = Math.min(availableStackSize, neededStackSize)) > 0) {
                ItemStack inSlot = stack.copy();
                inSlot.setCount(additionalStackSize);
                if (this.slot.hasItem()) {
                    inSlot.grow(this.slot.getItem().getCount());
                }
                this.slot.set(inSlot);
                stack.shrink(additionalStackSize);
                this.changed();
            }
        }
        return stack;
    }

    public static interface GuiSlotDist
    extends GuiControlDistHandler {
        public void changed();
    }
}

