/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.inventory;

import com.mojang.serialization.DynamicOps;
import java.util.BitSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.control.inventory.GuiSlot;
import team.creative.creativecore.common.gui.sync.GuiSyncGlobal;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;

public interface IGuiInventory {
    public static final GuiSyncGlobal<GuiControl, CompoundTag> SYNC = GuiSyncHolder.GLOBAL.register("inv_one", (control, nbt) -> {
        IGuiInventory inventory = (IGuiInventory)((Object)control);
        for (String name : nbt.keySet()) {
            int id = Integer.parseInt(name);
            inventory.getSlot((int)id).slot.set((ItemStack)nbt.read(name, ItemStack.OPTIONAL_CODEC).get());
            inventory.setChanged(id);
        }
    });
    public static final GuiSyncGlobal<GuiControl, ListTag> SYNC_ALL = GuiSyncHolder.GLOBAL.register("inv_all", (control, list) -> {
        IGuiInventory inventory = (IGuiInventory)((Object)control);
        for (int i = 0; i < inventory.inventorySize(); ++i) {
            inventory.getSlot((int)i).slot.set((ItemStack)ItemStack.OPTIONAL_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)list.getCompoundOrEmpty(i)).getOrThrow());
        }
        inventory.setChanged();
    });

    public GuiSlot getSlot(int var1);

    public int inventorySize();

    public String name();

    public void setChanged();

    public void setChanged(int var1);

    default public ItemStack moveInside(ItemStack toAdd, int slot) {
        return toAdd;
    }

    default public void insertClever(ItemStack toAdd) {
        this.insertClever(toAdd, 0, this.inventorySize());
    }

    default public void insertClever(ItemStack toAdd, int start, int endExclusive) {
        this.insert(toAdd, false, start, endExclusive);
        if (!toAdd.isEmpty()) {
            this.insert(toAdd, true, start, endExclusive);
        }
    }

    default public void insert(ItemStack toAdd, boolean useEmptySlot) {
        this.insert(toAdd, useEmptySlot, 0, this.inventorySize());
    }

    default public void insert(ItemStack toAdd, boolean useEmptySlot, int start, int endExclusive) {
        for (int i = start; i < endExclusive; ++i) {
            GuiSlot slot = this.getSlot(i);
            if (!useEmptySlot && !slot.slot.hasItem() || !(toAdd = slot.insert(toAdd)).isEmpty()) continue;
            return;
        }
    }

    default public void extract(ItemStack toDrain) {
        Player player = ((GuiControl)((Object)this)).getPlayer();
        for (int i = 0; i < this.inventorySize(); ++i) {
            int transfer;
            GuiSlot slot = this.getSlot(i);
            if (!slot.slot.mayPickup(player) || !ItemStack.isSameItemSameComponents((ItemStack)toDrain, (ItemStack)slot.getStack()) || (transfer = Math.min(toDrain.getCount(), slot.getStack().getCount())) <= 0) continue;
            ItemStack drained = slot.slot.remove(transfer);
            slot.slot.onTake(player, drained);
            toDrain.shrink(transfer);
            if (!toDrain.isEmpty()) continue;
            return;
        }
    }

    default public void sync(BitSet set) {
        GuiControl control = (GuiControl)((Object)this);
        if (control.isClient()) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        int i = set.nextSetBit(0);
        while (i >= 0) {
            GuiSlot slot = this.getSlot(i);
            slot.onSendUpdate();
            nbt.store("" + i, ItemStack.OPTIONAL_CODEC, (Object)slot.slot.getItem());
            i = set.nextSetBit(i + 1);
        }
        SYNC.send(control, nbt);
    }

    default public void syncAll() {
        GuiControl control = (GuiControl)((Object)this);
        if (control.isClient()) {
            return;
        }
        ListTag list = new ListTag();
        for (int i = 0; i < this.inventorySize(); ++i) {
            list.add((Object)((Tag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getSlot((int)i).slot.getItem()).getOrThrow()));
        }
        SYNC_ALL.send(control, list);
    }
}

