/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CreativeByteBuf;
import team.creative.creativecore.common.network.CreativeNetworkPacket;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetwork {
    private final HashMap<Class<? extends CreativePacket>, CreativeNetworkPacket> packetTypes = new HashMap();
    private final Logger logger;
    private final String modid;
    private String version;
    private PayloadRegistrar registrar;
    private int id = 0;

    public CreativeNetwork(int version, Logger logger, ResourceLocation location) {
        this.logger = logger;
        this.version = "" + version;
        this.modid = location.getNamespace();
        this.logger.debug("Created network " + String.valueOf(location));
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(this::register);
    }

    public void register(RegisterPayloadHandlersEvent event) {
        this.registrar = event.registrar(this.modid).versioned(this.version).optional();
        for (CreativeNetworkPacket packet : this.packetTypes.values()) {
            this.registerType(packet);
        }
    }

    private <T extends CreativePacket> void registerType(CreativeNetworkPacket<CreativePacket> handler) {
        IPayloadHandler executor = (packet, ctx) -> {
            try {
                ctx.enqueueWork(() -> packet.execute(ctx.player()));
            }
            catch (Throwable e) {
                CreativeCore.LOGGER.error("Executing a packet ran into an exception", e);
                CreativeCore.LOGGER.catching(e);
                throw e;
            }
        };
        this.registrar.playToServer(handler.cid, StreamCodec.ofMember((x, y) -> handler.write((CreativePacket)x, (CreativeByteBuf)((Object)y), PacketFlow.CLIENTBOUND), x -> handler.read((CreativeByteBuf)((Object)x), PacketFlow.CLIENTBOUND)), executor);
        this.registrar.playToClient(handler.sid, StreamCodec.ofMember((x, y) -> handler.write((CreativePacket)x, (CreativeByteBuf)((Object)y), PacketFlow.SERVERBOUND), x -> handler.read((CreativeByteBuf)((Object)x), PacketFlow.SERVERBOUND)), executor);
    }

    public <T extends CreativePacket> void registerType(Class<T> classType, Supplier<T> supplier) {
        CreativeNetworkPacket<CreativePacket> handler = new CreativeNetworkPacket<CreativePacket>(ResourceLocation.tryBuild((String)this.modid, (String)("" + this.id)), classType, supplier, false);
        this.packetTypes.put(classType, handler);
        if (this.registrar != null) {
            this.registerType(handler);
        }
        ++this.id;
    }

    public CreativeNetworkPacket getType(Class<? extends CreativePacket> clazz) {
        return this.packetTypes.get(clazz);
    }

    protected <T extends CreativePacket> T prepare(T packet, PacketFlow flow) {
        packet.setType(flow.isClientbound() ? this.packetTypes.get(packet.getClass()).cid : this.packetTypes.get(packet.getClass()).sid);
        return packet;
    }

    public void sendToServer(CreativePacket message) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)this.prepare(message, PacketFlow.CLIENTBOUND), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendToClient(CreativePacket message, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.prepare(message, PacketFlow.SERVERBOUND), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendToClient(CreativePacket message, Level level, BlockPos pos) {
        if (level instanceof ISubLevel) {
            this.sendToClientTracking(message, ((ISubLevel)level).getHolder());
        } else {
            this.sendToClient(message, level.getChunkAt(pos));
        }
    }

    public void sendToClient(CreativePacket message, LevelChunk chunk) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)chunk.getLevel()), (ChunkPos)chunk.getPos(), (CustomPacketPayload)this.prepare(message, PacketFlow.SERVERBOUND), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendToClientTracking(CreativePacket message, Entity entity) {
        Level level = entity.level();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.sendToClientTracking(message, sub.getHolder());
        } else {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)this.prepare(message, PacketFlow.SERVERBOUND), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendToClientTrackingAndSelf(CreativePacket message, Entity entity) {
        Level level = entity.level();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.sendToClientTrackingAndSelf(message, sub.getHolder());
        } else {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)this.prepare(message, PacketFlow.SERVERBOUND), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void sendToClientAll(MinecraftServer server, CreativePacket message) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)this.prepare(message, PacketFlow.SERVERBOUND), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

