/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.flow;

import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControlRect;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.type.list.MarkList;

public class GuiStackY
extends GuiFlow {
    @Override
    public int minWidth(List<? extends GuiControlRect> controls, int spacing, int availableWidth) {
        int width = 0;
        for (GuiControlRect guiControlRect : controls) {
            width = Math.max(width, guiControlRect.getMinWidth(availableWidth));
        }
        return width;
    }

    @Override
    public int preferredWidth(List<? extends GuiControlRect> controls, int spacing, int availableWidth) {
        int width = 0;
        for (GuiControlRect guiControlRect : controls) {
            width = Math.max(width, guiControlRect.getPreferredWidth(availableWidth));
        }
        return width;
    }

    @Override
    public int minHeight(List<? extends GuiControlRect> controls, int spacing, int width, int availableHeight) {
        int height = -spacing;
        boolean has = false;
        for (GuiControlRect guiControlRect : controls) {
            int min = guiControlRect.getMinHeight(availableHeight);
            if (min != -1) {
                height += min;
                has = true;
            }
            height += spacing;
        }
        return has ? height : -1;
    }

    @Override
    public int preferredHeight(List<? extends GuiControlRect> controls, int spacing, int width, int availableHeight) {
        int height = -spacing;
        for (GuiControlRect guiControlRect : controls) {
            height += guiControlRect.getPreferredHeight(availableHeight) + spacing;
        }
        return height;
    }

    @Override
    public void flowX(List<? extends GuiControlRect> controls, int spacing, Align align, int width, int preferred, boolean endless) {
        int maxWidth = width;
        if (endless && preferred > width) {
            maxWidth = preferred;
        }
        boolean expandable = GuiStackY.areChildrenExpandableX(controls);
        if (align == Align.LEFT && !expandable) {
            for (GuiControlRect guiControlRect : controls) {
                guiControlRect.setX(0);
                guiControlRect.setWidth(Math.min(maxWidth, guiControlRect.getPreferredWidth(width)), width);
                guiControlRect.flowX();
            }
        } else if (align == Align.STRETCH || expandable) {
            for (GuiControlRect guiControlRect : controls) {
                if (guiControlRect.isExpandableX() || align == Align.STRETCH) {
                    guiControlRect.setWidth(maxWidth, width);
                } else {
                    guiControlRect.setWidth(Math.min(maxWidth, guiControlRect.getPreferredWidth(width)), width);
                }
                guiControlRect.setX(0);
                guiControlRect.flowX();
            }
        } else if (align == Align.RIGHT) {
            for (GuiControlRect guiControlRect : controls) {
                guiControlRect.setWidth(Math.min(maxWidth, guiControlRect.getPreferredWidth(width)), width);
                guiControlRect.setX(maxWidth - guiControlRect.getWidth());
                guiControlRect.flowX();
            }
        } else {
            for (GuiControlRect guiControlRect : controls) {
                guiControlRect.setWidth(Math.min(maxWidth, guiControlRect.getPreferredWidth(width)), width);
                guiControlRect.setX((int)Math.ceil((double)maxWidth / 2.0 - (double)guiControlRect.getWidth() / 2.0));
                guiControlRect.flowX();
            }
        }
    }

    @Override
    public void flowY(List<? extends GuiControlRect> controls, int spacing, VAlign valign, int width, int height, int preferred, boolean endless) {
        block30: {
            int available;
            block31: {
                block29: {
                    available = height - spacing * (controls.size() - 1);
                    MarkList<? extends GuiControlRect> list = new MarkList<GuiControlRect>(controls);
                    if (height >= preferred) {
                        if (valign == VAlign.STRETCH && !GuiStackY.areChildrenExpandableY(controls)) {
                            for (GuiControlRect guiControlRect : list) {
                                int n = guiControlRect.getMinHeight(height);
                                if (n != -1) {
                                    available -= n;
                                    guiControlRect.setHeight(n, height);
                                    continue;
                                }
                                guiControlRect.setHeight(0, height);
                            }
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    GuiControlRect guiControlRect = (GuiControlRect)iterator.next();
                                    int toAdd = Maths.min(average, available, guiControlRect.getPreferredHeight(height) - guiControlRect.getHeight());
                                    if (toAdd <= 0) {
                                        iterator.mark();
                                        continue;
                                    }
                                    available -= guiControlRect.addHeight(toAdd, height);
                                    if (!guiControlRect.isMaxHeight(height)) continue;
                                    iterator.mark();
                                }
                            }
                            list.clear();
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    GuiControlRect guiControlRect = (GuiControlRect)iterator.next();
                                    available -= guiControlRect.addHeight(Math.min(average, available), height);
                                    if (!guiControlRect.isMaxHeight(height)) continue;
                                    iterator.mark();
                                }
                            }
                        } else {
                            Iterator itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiControlRect guiControlRect = (GuiControlRect)itr.next();
                                guiControlRect.setHeight(guiControlRect.getPreferredHeight(height), height);
                                if (!guiControlRect.isExpandableY()) {
                                    itr.mark();
                                }
                                available -= guiControlRect.getHeight();
                            }
                            if (valign == VAlign.STRETCH || GuiStackY.areChildrenExpandableY(controls)) {
                                while (available > 0 && !list.isEmpty()) {
                                    int average = (int)Math.ceil((double)available / (double)list.remaing());
                                    Iterator iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        GuiControlRect guiControlRect = (GuiControlRect)iterator.next();
                                        available -= guiControlRect.addHeight(Math.min(average, available), height);
                                        if (!guiControlRect.isMaxHeight(height)) continue;
                                        iterator.mark();
                                    }
                                }
                            }
                        }
                    } else if (endless) {
                        for (GuiControlRect guiControlRect : controls) {
                            guiControlRect.setHeight(guiControlRect.getPreferredHeight(height), height);
                        }
                        valign = VAlign.TOP;
                    } else {
                        for (GuiControlRect guiControlRect : list) {
                            int n = guiControlRect.getMinHeight(height);
                            if (n != -1) {
                                available -= n;
                                guiControlRect.setHeight(n, height);
                                continue;
                            }
                            guiControlRect.setHeight(0, height);
                        }
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiControlRect guiControlRect = (GuiControlRect)iterator.next();
                                int prefer = guiControlRect.getPreferredHeight(height);
                                available -= guiControlRect.addHeight(Math.min(average, Math.min(prefer - guiControlRect.getHeight(), available)), height);
                                if (!guiControlRect.isMaxHeight(height) && prefer > guiControlRect.getHeight()) continue;
                                iterator.mark();
                            }
                        }
                        list.clear();
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiControlRect guiControlRect = (GuiControlRect)iterator.next();
                                available -= guiControlRect.addHeight(Math.min(average, available), height);
                                if (!guiControlRect.isMaxHeight(height)) continue;
                                iterator.mark();
                            }
                        }
                    }
                    for (GuiControlRect guiControlRect : controls) {
                        guiControlRect.flowY();
                    }
                    if (available > 0 && valign != VAlign.TOP) break block29;
                    int y = 0;
                    for (GuiControlRect guiControlRect : controls) {
                        guiControlRect.setY(y);
                        y += guiControlRect.getHeight() + spacing;
                    }
                    break block30;
                }
                if (valign != VAlign.BOTTOM) break block31;
                int y = height;
                for (GuiControlRect guiControlRect : controls) {
                    guiControlRect.setY(y -= guiControlRect.getHeight());
                    y -= spacing;
                }
                break block30;
            }
            if (valign != VAlign.CENTER && valign != VAlign.STRETCH) break block30;
            int y = available / 2;
            for (GuiControlRect guiControlRect : controls) {
                guiControlRect.setY(y);
                y += guiControlRect.getHeight() + spacing;
            }
        }
    }
}

