/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiCheckList;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;

@OnlyIn(value=Dist.CLIENT)
@Environment(value=EnvType.CLIENT)
public abstract class GuiCreativeIngredientHandler {
    public static final NamedHandlerRegistry<GuiCreativeIngredientHandler> REGISTRY = new NamedHandlerRegistry<Object>(null);

    public static GuiCreativeIngredientHandler find(CreativeIngredient info) {
        if (info != null) {
            for (GuiCreativeIngredientHandler handler : REGISTRY.values()) {
                if (!handler.canHandle(info)) continue;
                return handler;
            }
        }
        return REGISTRY.getDefault();
    }

    public abstract boolean canHandle(CreativeIngredient var1);

    public abstract void createControls(GuiParent var1, CreativeIngredient var2);

    public abstract CreativeIngredient parseControls(GuiParent var1);

    public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
    }

    static {
        REGISTRY.registerDefault("Default", new GuiCreativeIngredientHandler(){

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                List<ResourceLocation> list;
                GuiStackSelector selector = (GuiStackSelector)new GuiStackSelector("inv", gui.getPlayer(), new GuiStackSelector.CreativeCollector(new GuiStackSelector.SearchSelector())).setExpandableX();
                gui.add((GuiControl)selector);
                if (info instanceof CreativeIngredientItemStack) {
                    CreativeIngredientItemStack s = (CreativeIngredientItemStack)info;
                    list = s.getIncluded();
                } else {
                    list = new ArrayList<ResourceLocation>();
                }
                gui.add((GuiControl)new GuiDataCheckList("list", false, null, list).setExpandable());
                if (info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack) {
                    selector.setSelectedForce(info.getExample().copy());
                }
                this.onChanged(gui, new GuiControlChangedEvent<GuiStackSelector>(selector));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack;
            }

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                ItemStack stack = gui.get("inv", GuiStackSelector.class).getSelected();
                if (stack != null) {
                    GuiDataCheckList list = (GuiDataCheckList)gui.get("list");
                    List<ResourceLocation> included = list.getConfiguredIncluded();
                    if (included.isEmpty()) {
                        if (!(Block.byItem((Item)stack.getItem()) instanceof AirBlock)) {
                            return new CreativeIngredientBlock(Block.byItem((Item)stack.getItem()));
                        }
                        return new CreativeIngredientItem(stack.getItem());
                    }
                    return new CreativeIngredientItemStack(stack, included);
                }
                return null;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                GuiControl guiControl;
                if (event.control.is("inv") && (guiControl = event.control) instanceof GuiStackSelector) {
                    GuiStackSelector selector = (GuiStackSelector)guiControl;
                    GuiDataCheckList list = (GuiDataCheckList)gui.get("list");
                    ItemStack stack = selector.getSelected();
                    TextMapBuilder<DataComponentType> map = new TextMapBuilder<DataComponentType>();
                    Object2BooleanArrayMap selected = new Object2BooleanArrayMap();
                    CompoundTag nbt = (CompoundTag)stack.saveOptional(gui.provider());
                    if (!(nbt = nbt.getCompound("components")).isEmpty()) {
                        for (String component : nbt.getAllKeys()) {
                            ResourceLocation location = ResourceLocation.parse((String)component);
                            DataComponentType type = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(location);
                            map.addComponent(type, (Component)Component.literal((String)component).append(": ").append((Component)Component.literal((String)nbt.get(component).getAsString()).withStyle(ChatFormatting.GRAY)));
                            if (!list.includes(type)) continue;
                            selected.put((Object)type, true);
                        }
                    }
                    list.set(map, selected);
                    gui.reflow();
                }
            }
        });
        REGISTRY.register("Blocktag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBox box = (GuiComboBox)gui.get("tag");
                TagKey tag = (TagKey)box.selected();
                if (tag != null) {
                    return new CreativeIngredientBlockTag((TagKey<Block>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBox<TagKey> box = new GuiComboBox<TagKey>("tag", new TextMapBuilder<TagKey>().addComponents(BuiltInRegistries.BLOCK.getTagNames().toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Optional tag = BuiltInRegistries.BLOCK.getTag(x);
                    if (tag.isPresent() && ((HolderSet.Named)tag.get()).size() > 0) {
                        builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).get(0).value()));
                    }
                    return builder.text(x.location().toString()).build();
                }));
                gui.add((GuiControl)box);
                gui.add((GuiControl)new GuiTextfield("search"));
                if (info instanceof CreativeIngredientBlockTag) {
                    box.select(((CreativeIngredientBlockTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlockTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBox box = (GuiComboBox)gui.get("tag");
                    box.set(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(BuiltInRegistries.BLOCK.getTagNames().toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Optional tag = BuiltInRegistries.BLOCK.getTag(x);
                        if (tag.isPresent() && ((HolderSet.Named)tag.get()).size() > 0) {
                            builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).get(0).value()));
                        }
                        return builder.text(x.location().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Itemtag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBox box = (GuiComboBox)gui.get("tag");
                TagKey tag = (TagKey)box.selected();
                if (tag != null) {
                    return new CreativeIngredientItemTag((TagKey<Item>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.flow = GuiFlow.STACK_Y;
                gui.align = Align.STRETCH;
                GuiComboBox<TagKey> box = new GuiComboBox<TagKey>("tag", new TextMapBuilder<TagKey>().addComponents(BuiltInRegistries.ITEM.getTagNames().toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Optional tag = BuiltInRegistries.ITEM.getTag(x);
                    if (tag.isPresent() && ((HolderSet.Named)tag.get()).size() > 0) {
                        builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).get(0).value()));
                    }
                    return builder.text(x.location().toString()).build();
                }));
                gui.add((GuiControl)box);
                gui.add((GuiControl)new GuiTextfield("search"));
                if (info instanceof CreativeIngredientItemTag) {
                    box.select(((CreativeIngredientItemTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientItemTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBox box = (GuiComboBox)gui.get("tag");
                    box.set(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(BuiltInRegistries.ITEM.getTagNames().toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Optional tag = BuiltInRegistries.ITEM.getTag(x);
                        if (tag.isPresent() && ((HolderSet.Named)tag.get()).size() > 0) {
                            builder.stack(new ItemStack((ItemLike)((HolderSet.Named)tag.get()).get(0).value()));
                        }
                        return builder.text(x.location().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Fuel", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                return new CreativeIngredientFuel();
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.add((GuiControl)new GuiLabel("info").setTitle((Component)Component.literal((String)"Nothing to select")));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientFuel;
            }
        });
    }

    public static class GuiDataCheckList
    extends GuiCheckList<DataComponentType<?>> {
        public List<ResourceLocation> included;

        public GuiDataCheckList(String name, boolean modifiable, TextMapBuilder<DataComponentType<?>> map, List<ResourceLocation> included) {
            super(name, modifiable, map, null);
            this.included = included;
        }

        public boolean includes(DataComponentType<?> type) {
            return this.included.contains(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(type));
        }

        public List<ResourceLocation> getConfiguredIncluded() {
            ArrayList<ResourceLocation> included = new ArrayList<ResourceLocation>();
            for (GuiCheckList.GuiCheckListRow row : this.rows) {
                if (!row.checkBox.value) continue;
                included.add(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)row.value)));
            }
            return included;
        }
    }
}

