package com.drathonix.loadmychunks.common.mixin;

import com.drathonix.loadmychunks.common.LoadMyChunks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Final;
import com.drathonix.loadmychunks.common.bridge.IEntitySectionMixin;
import net.minecraft.class_5568;
import net.minecraft.class_5572;
import net.minecraft.class_5573;
import net.minecraft.class_5584;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_5573.class)
public class MixinEntitySectionStorage<T extends class_5568> {
    @Shadow @Final private Class<T> entityClass;

    @Inject(method = "createSection",at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/entity/EntitySection;<init>(Ljava/lang/Class;Lnet/minecraft/world/level/entity/Visibility;)V"),cancellable = true,locals = LocalCapture.CAPTURE_FAILEXCEPTION)
    public void setCPos(long l, CallbackInfoReturnable<class_5572<T>> cir, long m, class_5584 visibility){
        class_5572<T> sec = new class_5572<>(this.entityClass,visibility);
        IEntitySectionMixin.setChunkPos(sec,m);
        cir.setReturnValue(sec);
    }
}
//?} else {
/*@Mixin(LoadMyChunks.class)
public class MixinEntitySectionStorage {}
*///?}
