package com.drathonix.loadmychunks.common.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_1297;

/**
 * Copy of the vanilla entity tick list implementation added POST 1.16.5.
 *
 * @author Jack Andersen
 * @since 1.2.0
 */
public class ProtectedEntityTickList {
    private Int2ObjectMap<class_1297> active = new Int2ObjectLinkedOpenHashMap<>();
    private Int2ObjectMap<class_1297> passive = new Int2ObjectLinkedOpenHashMap<>();
    @Nullable
    private Int2ObjectMap<class_1297> iterated;

    private void ensureActiveIsNotIterated() {
        if (this.iterated == this.active) {
            this.passive.clear();

            for (Int2ObjectMap.Entry<class_1297> entry : Int2ObjectMaps.fastIterable(this.active)) {
                this.passive.put(entry.getIntKey(), entry.getValue());
            }

            Int2ObjectMap<class_1297> int2objectmap = this.active;
            this.active = this.passive;
            this.passive = int2objectmap;
        }
    }

    public void add(class_1297 entity) {
        this.ensureActiveIsNotIterated();
        this.active.put(entity.method_5628(), entity);
    }

    public void remove(class_1297 entity) {
        this.ensureActiveIsNotIterated();
        this.active.remove(entity.method_5628());
    }

    public void clear(){
        this.ensureActiveIsNotIterated();
        this.active.clear();
    }

    public boolean contains(class_1297 entity) {
        return this.active.containsKey(entity.method_5628());
    }

    public void forEach(Consumer<class_1297> action) {
        if (this.iterated != null) {
            throw new UnsupportedOperationException("Only one concurrent iteration supported");
        } else {
            this.iterated = this.active;

            try {
                for (class_1297 entity : this.active.values()) {
                    action.accept(entity);
                }
            } finally {
                this.iterated = null;
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProtectedEntityTickList [active=");
        forEach(e->{
            builder.append(e.method_5667()).append(", ");
        });
        builder.append("]");
        return builder.toString();
    }
}
