package com.drathonix.loadmychunks.common.item;

import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.mojang.authlib.GameProfile;
import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.util.Message;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1838;
import net.minecraft.class_1923;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ItemChunkometer extends ItemHasTooltip {
    public ItemChunkometer(class_1793 properties) {
        super(properties,1);
    }

    @Override
    protected class_1269 useOnCtx(class_1838 useOnContext) {
        MultiversioningHelper.serverLevel(useOnContext.method_8045(),sl->{
            class_3222 player = (class_3222) useOnContext.method_8036();
            if(player == null){
                return;
            }
            class_1923 pos = new class_1923(player.method_24515());
            ChunkDataModule cdm = ChunkDataManager.getOrCreateChunkData(sl, pos);
            if (!LMCConfig.lagometerNeedsChunkOwnership || player.method_5687(2) || cdm.containsOwnedLoader(player.method_5667())) {
                class_5250 response = Message.styled(Message.translatable("loadmychunks.chunkinfo.line1", pos.field_9181, pos.field_9180),class_124.field_1068,true,false);
                Message.send(player,response);
                response = Message.styled(Message.empty(),class_124.field_1075,false,false);
                if (cdm.onCooldown()) {
                    response = Message.append(response,Message.translatable("loadmychunks.chunkinfo.line2.overticked"));
                } else {
                    if (cdm.getLoadState().shouldLoad()) {
                        if(cdm.getLoadState().shouldForceEntities()) {
                            response = Message.append(response,Message.translatable("loadmychunks.chunkinfo.line2.forced.entity_ticking"));
                        } else {
                            response = Message.append(response,Message.translatable("loadmychunks.chunkinfo.line2.forced"));
                        }
                    } else {
                        response = Message.append(response,Message.translatable("loadmychunks.chunkinfo.line2.notforced"));
                    }
                }
                response = Message.append(response,"\n");
                response = Message.append(response,Message.translatable("loadmychunks.chunkinfo.line3",cdm.getTickTimer().getDuration()));
                StringBuilder csl = new StringBuilder();
                Iterator<UUID> iterator = cdm.getPlayerOwners().iterator();
                while (iterator.hasNext()) {
                    UUID u = iterator.next();
                    Optional<GameProfile> profile = MultiversioningHelper.enforceOptional(sl.method_8503().method_3793().method_14512(u));
                    if (profile.isPresent()) {
                        csl.append(profile.get().getName());
                    } else {
                        csl.append(u.toString());
                    }
                    if (iterator.hasNext()) {
                        csl.append(", ");
                    }
                }
                if(!cdm.getLoaders().isEmpty()) {
                    response = Message.append(response,"\n");
                    response = Message.append(response, Message.translatable("loadmychunks.chunkinfo.line4", cdm.getLoaders().size(), csl.toString()));
                    if (cdm.onCooldown()) {
                        response = Message.append(response, "\n");
                        response = Message.append(response, Message.translatable("loadmychunks.chunkinfo.line5", cdm.getDisabledPeriod().getTimeRemaining() / 1000));
                    }
                }
                Message.send(player,response);
            }
            else{
                Message.send(player,Message.styled(Message.translatable("loadmychunks.chunkinfo.need_ownership"),class_124.field_1061,false,false));
            }
        });
        return class_1269.field_5812;
    }
}

