package com.drathonix.loadmychunks.common.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

//? if >1.16.5 {
import com.drathonix.loadmychunks.common.bridge.IEntitySectionMixin;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.bridge.ILevelChunkMixin;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_5568;
import net.minecraft.class_5572;
import net.minecraft.class_5584;

@Mixin(class_5572.class)
public abstract class MixinEntitySection<T extends class_5568> implements IEntitySectionMixin {
    @Shadow public abstract Stream<T> getEntities();

    @Unique
    private long lmc$longChunk;

    @Inject(method = "add",at = @At("TAIL"))
    public void addToChunkTicker(T entityAccess, CallbackInfo ci){
        try{
            if(entityAccess instanceof class_1297){
                class_1297 e = (class_1297) entityAccess;
                MultiversioningHelper.serverLevel(e,sl->{
                    ChunkDataManager.getOrCreateChunkData(sl, lmc$longChunk).lmc$addEntity(e);
                });
            }
        } catch (Exception e){
            e.printStackTrace();
        }
    }

    @Inject(method = "remove",at = @At("TAIL"))
    public void removeFromChunkTicker(T entityAccess, CallbackInfoReturnable<Boolean> cir){
        try {
            if (entityAccess instanceof class_1297) {
                class_1297 e = (class_1297) entityAccess;
                MultiversioningHelper.serverLevel(e, sl -> {
                    ChunkDataManager.getOrCreateChunkData(sl, lmc$longChunk).lmc$removeEntity(e);
                });
            }
        } catch (Exception e){
            e.printStackTrace();
        }
    }

    // This is only called when either the chunk holding the ent section is fully unloaded or enters full/block ticking/entity ticking status.
    // Without this mixin, when a section is loaded for the first time everything works as intended, however when the chunks containing said section become inaccessible this entity section persists. When the chunk reloads the entities contained in this section are not re-added to the lmc ticker.
    @Inject(method = "updateChunkStatus",at = @At("HEAD"))
    public void captureEntitiesAgain(class_5584 visibility, CallbackInfoReturnable<class_5584> cir){
        Optional<T> e = getEntities().findFirst();
        if(e.isPresent() && visibility.method_31883()) {
            MultiversioningHelper.serverLevel((class_1297)e.get(),sl->{
                ChunkDataModule module = ChunkDataManager.getOrCreateChunkData(sl, lmc$longChunk);
                getEntities().forEach(ent -> {
                    module.lmc$addEntity((class_1297)ent);
                });
            });
        }
    }

    @Override
    public void lmc$setChunkPos(long pos) {
        lmc$longChunk=pos;
    }
}
//?} else {
/*import com.drathonix.loadmychunks.common.LoadMyChunks;
@Mixin(LoadMyChunks.class)
public class MixinEntitySection{

}
*///?}
