package com.drathonix.loadmychunks.common.registry;

import com.drathonix.loadmychunks.common.LoadMyChunks;
import com.drathonix.loadmychunks.common.block.BlockChunkLoader;
import com.drathonix.loadmychunks.common.block.BlockLagometer;
import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityLagometer;
import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityChunkLoader;
import com.drathonix.loadmychunks.common.debug.LoadMyChunksDebug;
import com.drathonix.loadmychunks.common.item.*;
import com.drathonix.loadmychunks.common.util.ModResource;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.drathonix.loadmychunks.unified.BlockEntityTypeBuilder;
//? if <=1.16.5 {
/*import me.shedaniel.architectury.registry.CreativeTabs;
import me.shedaniel.architectury.registry.DeferredRegister;
import me.shedaniel.architectury.registry.RegistrySupplier;
*///?}
//? if >1.16.5 {
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_7924;

public class LMCContent {
    //? if >1.19.4 {
    private static final DeferredRegister<class_1761> TABS = DeferredRegister.create(LoadMyChunks.MOD_ID, class_7924.field_44688);
    //?}
    public static final Map<String,RegistrySupplier<class_2248>> chunkLoaderBlockMap = new HashMap<>();
    public static RegistrySupplier<class_2591<BlockEntityChunkLoader>> chunkLoaderBlockEntity;
    public static RegistrySupplier<class_2591<BlockEntityLagometer>> lagometerBlockEntity;


    public static RegistrySupplier<class_1792> itemTickometer;
    public static RegistrySupplier<class_1792> itemPlayerSpoofer;
    public static RegistrySupplier<class_1792> itemLifeforceBroadcaster;
    public static RegistrySupplier<class_1792> itemLocatingCore;
    public static RegistrySupplier<class_1792> itemDiamondWire;
    public static RegistrySupplier<ItemChunkLoaderExtension> itemExtension;
    public static RegistrySupplier<ItemChunkometer> itemChunkometer;
    public static RegistrySupplier<class_2248> lagometerBlock;
    public static RegistrySupplier<class_2248> chunkLoaderBlock;

    //? if <=1.19.3 || >1.19.4
    public static RegistrySupplier<class_1761> creativeTab;
    //? if >1.19.3 && <1.19.5
    /*public static CreativeTabRegistry.TabSupplier creativeTab;*/

    public static void init() {
        //? if <=1.18.1
        /*creativeTab = new FakeRegistrySupplier<>(CreativeTabs.create(ModResource.of("creative_tab"),()->LMCRegistrar.ITEM.get(ModResource.of("chunk_loader")).getDefaultInstance()));*/
        //? if <1.19.3 && >1.18.1
        /*creativeTab = new FakeRegistrySupplier<>(CreativeTabRegistry.create(ModResource.of("creative_tab"),()->LMCRegistrar.ITEM.get(ModResource.of("chunk_loader")).getDefaultInstance()));*/
        //? if >1.19.3 && <1.19.5
        /*creativeTab = CreativeTabRegistry.create(ModResource.of("creative_tab"),()->LMCRegistrar.ITEM.get(ModResource.of("chunk_loader")).getDefaultInstance());*/
        //? if >1.20.0 {
        creativeTab = TABS.register(ModResource.of("creative_tab"),()-> CreativeTabRegistry.create(class_2561.method_43471("loadmychunks.creativetab.title"),()->LMCRegistrar.ITEM.get(ModResource.of("chunk_loader")).method_7854()));
        TABS.register();
        //?}
        LMCRegistrar.BLOCK.queue(reg->{
            chunkLoaderBlock = registerCLBlockWithItem(reg,"chunk_loader", () -> {
                return new BlockChunkLoader(MultiversioningHelper.properties("chunk_loader",50f,1200f));
            });
            String[] colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
            for (String color : colors) {
                RegistrySupplier<class_2248> block = registerCLBlockWithItem(reg,color + "_chunk_loader", () -> {
                    return new BlockChunkLoader(MultiversioningHelper.properties(color + "_chunk_loader",50f,1200f));
                });
                chunkLoaderBlockMap.put(color, block);
            }
            chunkLoaderBlockMap.put("",chunkLoaderBlock);
            lagometerBlock = registerBlockWithItem(reg,"lagometer",()->{
                return new BlockLagometer(MultiversioningHelper.properties("lagometer",3.5f,4f));
            }, ItemLagometer::new);
        });
        LMCRegistrar.ITEM.queue(reg->{
            itemTickometer = reg.register(ModResource.of("tickometer"), () -> new ItemHasTooltip(new LMCProperties("tickometer"),1));
            itemPlayerSpoofer = reg.register(ModResource.of("player_spoofer"), () -> new ItemHasTooltip(new LMCProperties("player_spoofer"),3));
            itemLocatingCore = reg.register(ModResource.of("dimensional_locator"), () -> new ItemHasTooltip(new LMCProperties("dimensional_locator"),2));
            itemDiamondWire = reg.register(ModResource.of("diamond_wire"), () -> new ItemHasTooltip(new LMCProperties("diamond_wire"),3));
            itemChunkometer = reg.register(ModResource.of("chunkometer"), () -> new ItemChunkometer(new LMCProperties("chunkometer")));
            itemExtension = reg.register(ModResource.of("chunk_loader_extension"), () -> new ItemChunkLoaderExtension(new LMCProperties("chunk_loader_extension")));
            itemLifeforceBroadcaster = reg.register(ModResource.of("lifeforce_broadcaster"), () -> new ItemLifeforceBroadcaster(new LMCProperties("lifeforce_broadcaster")));
        });

        LMCRegistrar.BLOCK_ENTITY_TYPE.queue(reg->{
            chunkLoaderBlockEntity = reg.register(ModResource.of("chunk_loader"), () -> BlockEntityTypeBuilder.make(BlockEntityChunkLoader::new,chunkLoaderBlockMap.values()));
            lagometerBlockEntity = reg.register(ModResource.of("lagometer"), ()-> BlockEntityTypeBuilder.make(BlockEntityLagometer::new, lagometerBlock));
        });

        if(LoadMyChunks.allowUsingDebugFeatures()){
            LoadMyChunksDebug.init();
        }

        LMCRegistrar.init();
    }

    public static <T extends class_2248> RegistrySupplier<T> registerBlockWithItem(DeferredRegister<class_2248> reg, String name, Supplier<? extends T> supplier) {
        class_2960 resource = ModResource.of(name);
        RegistrySupplier<T> block = reg.register(resource, supplier);
        LMCRegistrar.ITEM.queue(ireg->{
            ireg.register(resource, () -> new class_1747(block.get(), new LMCProperties(name)));
        });
        return block;
    }

    public static <T extends class_2248> RegistrySupplier<T> registerBlockWithItem(DeferredRegister<class_2248> reg, String name, Supplier<? extends T> supplier, BiFunction<class_2248, LMCProperties, class_1747> function) {
        class_2960 resource = ModResource.of(name);
        RegistrySupplier<T> block = reg.register(resource, supplier);
        LMCRegistrar.ITEM.queue(ireg->{
            ireg.register(resource, () -> function.apply(block.get(),new LMCProperties(name)));
        });
        return block;
    }

    public static <T extends class_2248> RegistrySupplier<T> registerCLBlockWithItem(DeferredRegister<class_2248> reg, String name, Supplier<? extends T> supplier) {
        class_2960 resource = ModResource.of(name);
        RegistrySupplier<T> block = reg.register(resource, supplier);
        LMCRegistrar.ITEM.queue(ireg->{
            ireg.register(resource, () -> new ItemChunkLoader(block.get(), new LMCProperties(name)));
        });
        return block;
    }
}