package com.drathonix.loadmychunks.common.system.loaders.extension;

import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import net.minecraft.class_1923;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IExtensionChunkLoader<T extends IChunkLoader> extends IChunkLoader {
    default @Nullable T getPrimaryHostLoader(){
        return getHost(0);
    }

    default int getExtensionDistance() {
        IChunkLoader loader = getPrimaryHostLoader();
        if(loader != null){
            class_1923 host = loader.getChunkPos();
            class_1923 extension = getChunkPos();
            return Math.max(Math.abs(host.field_9181-extension.field_9181), Math.abs(host.field_9180-extension.field_9180));
        }
        return -1;
    }

    /**
     * Accepts only AtomicReference of IChunkLoader and IChunkLoaders
     */
    void removeHost(Object host);

    default boolean isUnhosted(){
        return getNumberOfHosts() <= 0;
    }

    default boolean isHosted(){
        return getNumberOfHosts() > 0;
    }

    @Override
    default boolean shouldPersist() {
        return isHosted();
    }

    /**
     * Accepts only AtomicReference of IChunkLoader and IChunkLoaders
     */
    void addHost(Object host);

    T getHost(int i);

    int getNumberOfHosts();

    default boolean willRemoveHost(@NotNull Object host){
        for (int i = 0; i < getNumberOfHosts(); i++) {
            if(getHost(i) == host){
                return true;
            }
        }
        return false;
    }

    default void removeHostAndUnload(class_3218 level, @NotNull Object host) {
        //Remove from the world first to ensure the host loader instance is not lost.
        if(willRemoveHost(host) && getNumberOfHosts() <= 1){
            ChunkDataManager.removeChunkLoader(level, this.getChunkPos(), this);
        }
        removeHost(host);
    }

    @Override
    default ILoadState getActiveState() {
        if(isHosted()){
            ILoadState state = LoadStateRegistry.DISABLED;
            for (int i = 0; i < getNumberOfHosts(); i++) {
                state = getHost(i).getActiveState().getSuperiorLoadState(state);
            }
            return state;
        }
        else{
            return LoadStateRegistry.DISABLED;
        }
    }
}
