/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.config.regis;

import com.drathonix.loadmychunks.common.util.ModResource;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public abstract class RegistryRetriever<T> {
    protected ResourceLocation location;
    private T object;

    public RegistryRetriever(String key) {
        this(ModResource.parse(RegistryRetriever.convertOldPatch(key)));
    }

    private static String convertOldPatch(String val) {
        for (int i = 0; i < val.length(); ++i) {
            if (val.charAt(i) == ':') {
                return val;
            }
            if (val.charAt(i) != '.') continue;
            return val.replaceFirst("\\.", ":");
        }
        return val;
    }

    public RegistryRetriever(ResourceLocation location) {
        this.location = location;
    }

    abstract T retrieve();

    public String serializable() {
        return this.location.toString();
    }

    public T get() {
        if (this.object == null) {
            this.object = this.retrieve();
        }
        return this.object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RegistryRetriever that = (RegistryRetriever)object;
        return Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hashCode(this.location);
    }
}

