/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.mixin.cct;

import com.drathonix.loadmychunks.common.integ.cct.bridge.ITurtleBrainMixin;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.TurtleMoveCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TurtleMoveCommand.class})
public class MixinTurtleMoveCommand {
    @Inject(method={"execute(Ldan200/computercraft/api/turtle/ITurtleAccess;)Ldan200/computercraft/api/turtle/TurtleCommandResult;"}, at={@At(value="INVOKE", target="Ldan200/computercraft/api/turtle/ITurtleAccess;teleportTo(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    public void changeLogic(ITurtleAccess turtle, CallbackInfoReturnable<TurtleCommandResult> cir, Direction direction, ServerLevel oldWorld, BlockPos oldPosition, BlockPos newPosition) {
        boolean stable = oldWorld.isLoaded(newPosition);
        if (turtle instanceof ITurtleBrainMixin && ((ITurtleBrainMixin)turtle).lmc$preMove(oldWorld, newPosition)) {
            stable = true;
        }
        if (!stable) {
            cir.setReturnValue((Object)TurtleCommandResult.failure((String)"Cannot enter unloaded area"));
        }
    }

    @Overwrite
    private static TurtleCommandResult canEnter(TurtlePlayer turtlePlayer, ServerLevel world, BlockPos position) {
        if (world.isOutsideBuildHeight(position)) {
            return TurtleCommandResult.failure((String)(position.getY() < 0 ? "Too low to move" : "Too high to move"));
        }
        if (!world.isInWorldBounds(position)) {
            return TurtleCommandResult.failure((String)"Cannot leave the world");
        }
        if (turtlePlayer.isBlockProtected(world, position)) {
            return TurtleCommandResult.failure((String)"Cannot enter protected area");
        }
        if (!world.getWorldBorder().isWithinBounds(position)) {
            return TurtleCommandResult.failure((String)"Cannot pass the world border");
        }
        return TurtleCommandResult.success();
    }
}

