/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.loaders.extension;

import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.extension.IExtensionChunkLoader;
import com.drathonix.loadmychunks.common.util.ReferenceHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class ExtensionChunkLoaders
extends Long2ObjectOpenHashMap<IExtensionChunkLoader<?>> {
    private final ServerLevel level;
    private final Object host;

    public ExtensionChunkLoaders(ServerLevel level, Object host) {
        ReferenceHelper.assertIsType(IChunkLoader.class, host);
        this.level = level;
        this.host = host;
    }

    public synchronized <T extends IExtensionChunkLoader<?>> void recompute(Class<T> extensionType, int range, Factory<T> factory) {
        for (IExtensionChunkLoader extensionChunkLoader : this.values()) {
            extensionChunkLoader.removeHostAndUnload(this.level, this.host);
        }
        this.clear();
        if (range < 1) {
            return;
        }
        ChunkPos hostPos = ReferenceHelper.get(IChunkLoader.class, this.host).getChunkPos();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (z == 0 && x == 0) continue;
                ChunkPos pos = new ChunkPos(x, z);
                long gridPos = pos.toLong();
                ChunkPos cp = new ChunkPos(hostPos.x + x, hostPos.z + z);
                IExtensionChunkLoader loader = ChunkDataManager.computeChunkLoaderIfAbsent(this.level, cp, extensionType, present -> true, () -> factory.create(cp));
                loader.addHost(this.host);
                this.put(gridPos, loader);
            }
        }
    }

    public synchronized IExtensionChunkLoader<?> remove(long k) {
        IExtensionChunkLoader ecl = (IExtensionChunkLoader)super.remove(k);
        if (ecl != null) {
            ecl.removeHostAndUnload(this.level, this.host);
        }
        return ecl;
    }

    public void requestUpdates() {
        for (IExtensionChunkLoader ecl : this.values()) {
            ChunkDataManager.requestUpdate(this.level, ecl.getChunkPos());
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends IExtensionChunkLoader<?>> {
        public T create(ChunkPos var1);
    }
}

