/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.io.parser;

import com.vicious.persist.except.ParserException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class TokenView {
    private final InputStream stream;
    public char[] tokens = new char[3];

    public TokenView(InputStream stream) {
        this.stream = stream;
        Arrays.fill(this.tokens, ' ');
        try {
            this.read();
        }
        catch (IOException e) {
            throw new ParserException("Failed to initialize token view.", e);
        }
    }

    public void read() throws IOException {
        for (int i = 1; i < this.tokens.length; ++i) {
            this.tokens[i - 1] = this.tokens[i];
        }
        if (this.stream.available() > 0) {
            this.tokens[this.tokens.length - 1] = (char)this.stream.read();
        } else {
            this.tokens[2] = '\u0000';
        }
    }

    public char getLastToken() {
        return this.tokens[0];
    }

    public char getCurrentToken() {
        return this.tokens[1];
    }

    public char getNextToken() {
        return this.tokens[2];
    }

    public boolean isSafe() throws IOException {
        return this.tokens[2] != '\u0000';
    }

    public String toString() {
        StringBuilder out = new StringBuilder("[");
        for (int i = 0; i < this.tokens.length; ++i) {
            char c = this.tokens[i];
            Object name = Character.isLetterOrDigit(c) ? "" + c : Character.getName(c);
            out.append((String)name);
            if (i == this.tokens.length - 1) continue;
            out.append(',');
        }
        return String.valueOf(out) + "]";
    }
}

