package com.drathonix.loadmychunks.common.system.loaders;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.LoaderTypeKeys;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.control.LoadStateEnum;
import com.drathonix.loadmychunks.common.system.loaders.extension.ExtensionChunkLoaders;
import com.drathonix.loadmychunks.common.system.loaders.extension.IExtensionChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.extension.PlacedExtensionChunkLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class PlacedChunkLoader implements IChunkLoader,IOwnable {
    @Nullable protected ExtensionChunkLoaders extensions = null;
    protected int extensionRange = 0;
    @Nullable protected UUID owner;
    protected class_2338 position;
    protected ILoadState defaultState = LMCConfig.placedChunkLoaderDefaultLevel.get();
    protected ILoadState loadState = defaultState;
    protected long activityEnd = -1;

    public PlacedChunkLoader(){
    }

    public PlacedChunkLoader(class_2338 pos){
        this.position = pos;
    }
    public PlacedChunkLoader(class_2338 pos, long activityEnd){
        this.position = pos;
        this.activityEnd=activityEnd;
    }
    public PlacedChunkLoader(class_2338 pos, @Nullable UUID owner){
        this.position = pos;
        this.owner = owner;
    }

    @Override
    public @NotNull class_2487 save(class_2487 tag) {
        if(hasOwner()) {
            tag.method_25927("owner", owner);
        }
        if(hasExtensions()){
            tag.method_10569("extensions",extensionRange);
        }
        tag.method_10544("duration", activityEnd);
        loadState.putCompound("state",tag);
        defaultState.putCompound("default",tag);
        tag.method_10544("pos",position.method_10063());
        return tag;
    }

    @Override
    public void load(@NotNull class_2487 tag, class_3218 level) throws DoNotAddException {
        position = class_2338.method_10092(tag.method_10537("pos"));
        if(tag.method_10545("owner")){
            owner = tag.method_25926("owner");
        }
        if(tag.method_10545("duration")){
            activityEnd = tag.method_10537("duration");
        }
        defaultState = LoadStateRegistry.fromCompound("default",tag,LoadStateRegistry.TICKING);
        loadState = LoadStateRegistry.fromCompound("state",tag,defaultState);
        if(tag.method_10545("extensions")){
            extend(level,tag.method_10550("extensions"));
        }
    }

    @Override
    public void postLoad(class_3218 level) throws DoNotAddException {
    // TODO: fix this so that postLoad is caused after the entire chunk is loaded.
       // if(!(level.getBlockEntity(position) instanceof IHasChunkloader)){
      //      throw new DoNotAddException();
       // }
    }

    @Override
    public void setExtensionRange(int extensionRange) {
        this.extensionRange = extensionRange;
    }

    @Override
    public void setExtensionsMap(ExtensionChunkLoaders extensions) {
        this.extensions=extensions;
    }

    public int getExtensionRange(){
        return extensionRange;
    }

    public PlacedExtensionChunkLoader createExtension(class_1923 position) {
        return new PlacedExtensionChunkLoader(position,this);
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T extends IExtensionChunkLoader<?>> Class<T> getExtensionClass() {
        return (Class<T>) PlacedExtensionChunkLoader.class;
    }

    @Override
    public boolean supportsExtensions() {
        return true;
    }

    @Override
    public boolean supportsEntityTicking() {
        return true;
    }

    @Override
    public @Nullable ExtensionChunkLoaders getExtensionChunkLoaders() {
        return extensions;
    }

    @Override
    public ExtensionChunkLoaders.Factory<?> getExtensionFactory() {
        return this::createExtension;
    }

    @Override
    public @Nullable UUID getOwner() {
        return owner;
    }

    protected boolean outOfTime(){
        return shouldConsumeItems() && activityEnd == -1;
    }

    @Override
    public ILoadState getActiveState() {
        if(hasExceededChunkLimit() || outOfTime()){
            return LoadStateEnum.DISABLED;
        }
        return loadState;
    }

    @Override
    public ILoadState getDefaultState() {
        return defaultState;
    }

    @Override
    public void setActiveState(ILoadState state) {
        this.loadState =state;
    }

    @Override
    public void setOwner(@NotNull UUID owner) {
        this.owner=owner;
    }

    public @NotNull class_2338 getPosition() {
        return position;
    }

    @Override
    public class_2960 getTypeId() {
        return LoaderTypeKeys.PLACED_LOADER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PlacedChunkLoader that = (PlacedChunkLoader) o;
        return Objects.equals(position, that.position);
    }

    @Override
    public int hashCode() {
        return Objects.hash(position);
    }

    @Override
    public @NotNull class_1923 getChunkPos() {
        return new class_1923(getPosition());
    }

    @Override
    public long getActivityEnd() {
        return activityEnd;
    }

    @Override
    public void setActivityEnd(long activityEnd) {
        this.activityEnd = activityEnd;
    }

    @Override
    public @NotNull class_2338 getItemSource() {
        return position.method_10084();
    }

    @Override
    public ILoadState setDefaultState(ILoadState defaultState) {
        ILoadState prev = this.defaultState;
        this.defaultState = defaultState;
        // Will be this unless disabled by CCT
        if(this.loadState == LoadStateRegistry.TICKING){
            this.loadState=defaultState;
        }
        return prev;
    }
}
