package com.drathonix.loadmychunks.common.util;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class BoolArgument implements ArgumentType<Boolean> {
    //? if <1.18.3 {
    /*private static final Dynamic2CommandExceptionType INVALID_BOOL = new Dynamic2CommandExceptionType(
            (found, constants) -> new TranslatableComponent("commands.loadmychunks.arguments.bool.invalid", constants, found));
    *///?}
    //? if >1.18.2 {
    private static final Dynamic2CommandExceptionType INVALID_BOOL = new Dynamic2CommandExceptionType(
            (found, constants) -> class_2561.method_43469("commands.loadmychunks.arguments.bool.invalid", constants, found));
    //?}

    public static BoolArgument boolArgument() {
        return new BoolArgument();
    }

    @Override
    public Boolean parse(final StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Boolean.parseBoolean(name) || name.equalsIgnoreCase("ON");
        } catch (Throwable e) {
            throw INVALID_BOOL.createWithContext(reader, name, getExamples().toString());
        }
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(final CommandContext<S> context, final SuggestionsBuilder builder) {
        return class_2172.method_9265(getExamples(), builder);
    }

    private static final List<String> examples = new ArrayList<>();
    static {
        examples.add("TRUE");
        examples.add("FALSE");
        examples.add("ON");
        examples.add("OFF");
    }

    @Override
    public Collection<String> getExamples() {
        return examples;
    }

    //? if >1.18.2 {
    public static class Info implements class_2314<BoolArgument, Info.Template>
    {
        @Override
        public void serializeToNetwork(Template template, class_2540 buffer) {}

        @SuppressWarnings("unchecked")
        @Override
        public Template method_10005(class_2540 buffer)
        {
            return new Template();
        }

        @Override
        public void serializeToJson(Template template, JsonObject json) {}

        @Override
        public Template unpack(BoolArgument argument)
        {
            return new Template();
        }

        public class Template implements class_2314.class_7217<BoolArgument>
        {
            Template() {}

            @Override
            public BoolArgument method_41730(class_7157 p_223435_)
            {
                return new BoolArgument();
            }

            @Override
            public class_2314<BoolArgument, ?> method_41728()
            {
                return Info.this;
            }
        }
    }
    //?}
}