/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_5268;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkDataManager {
    private static final Map<class_3218, LevelChunkLoaderManager> levelManagers = new IdentityHashMap<class_3218, LevelChunkLoaderManager>();

    public static synchronized boolean hasExceededOwnershipCap(UUID uuid) {
        return ChunkDataManager.hasExceededOwnershipCap(uuid, 0);
    }

    public static synchronized boolean hasExceededOwnershipCap(UUID uuid, int added) {
        if (uuid == null) {
            uuid = class_156.field_25140;
        }
        if (LMCConfig.limitSettings.enabledForEnvironment && uuid == class_156.field_25140) {
            return ChunkDataManager.getCountLoadedChunksOf(uuid) + added > LMCConfig.limitSettings.limit;
        }
        if (LMCConfig.limitSettings.enabledForPlayers) {
            return ChunkDataManager.getCountLoadedChunksOf(uuid) + added > LMCConfig.limitSettings.limit;
        }
        return false;
    }

    public static synchronized void markChunkOwnedBy(class_3218 level, long longChunkPos, @Nullable UUID uuid) {
        ChunkDataManager.getManager(level).markChunkOwnedBy(longChunkPos, uuid);
        if (ChunkDataManager.hasExceededOwnershipCap(uuid)) {
            ChunkDataManager.updateCDMSofUUID(uuid);
        }
    }

    public static synchronized void markChunkNotOwnedBy(class_3218 level, long longChunkPos, @Nullable UUID uuid) {
        ChunkDataManager.getManager(level).markChunkNotOwnedBy(longChunkPos, uuid);
        if (!ChunkDataManager.hasExceededOwnershipCap(uuid)) {
            ChunkDataManager.updateCDMSofUUID(uuid);
        }
    }

    public static void updateCDMSofUUID(UUID uuid) {
        for (class_3218 serverLevel : levelManagers.keySet()) {
            LevelChunkLoaderManager value = levelManagers.get(serverLevel);
            LongIterator longIterator = value.forcedChunksByUUID.getOrDefault(uuid, new LongOpenHashSet()).iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                ChunkDataModule cdm = value.getOrCreateData(l);
                ILoadState loadState = cdm.getLoadState();
                cdm.update();
                cdm.updateChunkLoadState(serverLevel, loadState);
            }
        }
    }

    public static synchronized LevelChunkLoaderManager getManager(class_3218 level) {
        return levelManagers.computeIfAbsent(level, k -> new LevelChunkLoaderManager(level));
    }

    public static synchronized LevelChunkLoaderManager loadManager(class_3218 level, class_2487 tag) {
        LevelChunkLoaderManager manager = ChunkDataManager.getManager(level);
        manager.load(tag);
        return manager;
    }

    @NotNull
    public static Map<String, List<IChunkLoader>> getChunkLoadersOf(@Nullable UUID owner) {
        if (owner == null) {
            return new HashMap<String, List<IChunkLoader>>();
        }
        HashMap<String, List<IChunkLoader>> results = new HashMap<String, List<IChunkLoader>>();
        for (LevelChunkLoaderManager value : levelManagers.values()) {
            List loaders = results.computeIfAbsent(value.getLevelName(), k -> new ArrayList());
            for (ChunkDataModule dataModule : value.getChunkDataModules()) {
                for (IChunkLoader loader : dataModule.getLoaders()) {
                    if (!(loader instanceof IOwnable) || !owner.equals(((IOwnable)((Object)loader)).getOwner())) continue;
                    loaders.add(loader);
                }
            }
        }
        return results;
    }

    public static int getCountChunkLoadersOf(@NotNull UUID owner) {
        if (owner == null) {
            return 0;
        }
        int count = 0;
        for (LevelChunkLoaderManager value : levelManagers.values()) {
            for (ChunkDataModule dataModule : value.getChunkDataModules()) {
                for (IChunkLoader loader : dataModule.getLoaders()) {
                    if (!(loader instanceof IOwnable) || !owner.equals(((IOwnable)((Object)loader)).getOwner())) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static synchronized int getCountLoadedChunksOf(@NotNull UUID owner) {
        int count = 0;
        for (LevelChunkLoaderManager value : levelManagers.values()) {
            count += value.getCountLoadedChunksOf(owner);
        }
        return count;
    }

    public static void markShutDown(class_3218 level, class_1923 chunkPos, ILoadState previous) {
        ChunkDataManager.getManager(level).shutDown(chunkPos, previous);
    }

    public static void removeChunkLoader(class_3218 level, class_2338 pos, IChunkLoader loader) {
        ChunkDataManager.removeChunkLoader(level, new class_1923(pos), loader);
    }

    public static void removeChunkLoader(class_3218 level, class_1923 pos, IChunkLoader loader) {
        ChunkDataManager.getManager(level).removeChunkLoader(loader, pos);
    }

    public static void removeChunkLoader(class_3218 level, long pos, IChunkLoader loader) {
        ChunkDataManager.getManager(level).removeChunkLoader(loader, pos);
    }

    public static void addChunkLoader(class_3218 level, class_2338 pos, IChunkLoader loader) {
        ChunkDataManager.addChunkLoader(level, new class_1923(pos), loader);
    }

    public static void addChunkLoader(class_3218 level, class_1923 pos, IChunkLoader loader) {
        ChunkDataManager.getManager(level).addChunkLoader(loader, pos);
    }

    public static void addChunkLoader(class_3218 level, long pos, IChunkLoader loader) {
        ChunkDataManager.getManager(level).addChunkLoader(loader, pos);
    }

    @NotNull
    public static ChunkDataModule getOrCreateChunkData(class_3218 level, class_2338 pos) {
        return ChunkDataManager.getOrCreateChunkData(level, new class_1923(pos));
    }

    @NotNull
    public static ChunkDataModule getOrCreateChunkData(class_3218 level, class_1923 pos) {
        return ChunkDataManager.getManager(level).getOrCreateData(pos);
    }

    @NotNull
    public static ChunkDataModule getOrCreateChunkData(class_3218 level, long pos) {
        return ChunkDataManager.getManager(level).getOrCreateData(pos);
    }

    public static <T extends IChunkLoader> T computeChunkLoaderIfAbsent(class_3218 sl, class_2338 blockPos, Class<T> type, boolean doAdd, Predicate<T> predicate, Supplier<T> supplier) {
        return ChunkDataManager.getManager(sl).computeChunkLoaderIfAbsent(blockPos, type, doAdd, predicate, supplier);
    }

    public static <T extends IChunkLoader> T computeChunkLoaderIfAbsent(class_3218 sl, class_1923 chunkPos, Class<T> type, boolean doAdd, Predicate<T> predicate, Supplier<T> supplier) {
        return ChunkDataManager.getManager(sl).computeChunkLoaderIfAbsent(chunkPos, type, doAdd, predicate, supplier);
    }

    public static <T extends IChunkLoader> T computeChunkLoaderIfAbsent(class_3218 sl, class_2338 blockPos, Class<T> type, Predicate<T> predicate, Supplier<T> supplier) {
        return ChunkDataManager.getManager(sl).computeChunkLoaderIfAbsent(blockPos, type, true, predicate, supplier);
    }

    public static <T extends IChunkLoader> T computeChunkLoaderIfAbsent(class_3218 sl, class_1923 chunkPos, Class<T> type, Predicate<T> predicate, Supplier<T> supplier) {
        return ChunkDataManager.getManager(sl).computeChunkLoaderIfAbsent(chunkPos, type, true, predicate, supplier);
    }

    public static void clear() {
        for (LevelChunkLoaderManager value : levelManagers.values()) {
            value.clear();
        }
        levelManagers.clear();
    }

    public static void setDirty(class_3218 level) {
        ChunkDataManager.getManager(level).method_80();
    }

    public static boolean isForced(class_3218 level, class_1923 pos) {
        return ChunkDataManager.getOrCreateChunkData(level, pos).getLoadState().shouldLoad();
    }

    public static synchronized void handleConfigReload() {
        for (class_3218 level : levelManagers.keySet()) {
            LevelChunkLoaderManager value = levelManagers.get(level);
            value.configReloaded = true;
        }
    }

    public static synchronized void requestUpdate(class_3218 level, class_1923 chunkPos) {
        ChunkDataManager.getManager(level).requestUpdate(chunkPos);
    }

    public static void onChunkLoaded(class_3218 level, class_2791 chunk) {
        ChunkDataManager.getOrCreateChunkData(level, chunk.method_12004()).postLoad(level, chunk);
    }

    public static class LevelChunkLoaderManager
    extends class_18 {
        protected final Long2ObjectLinkedOpenHashMap<List<Consumer<ChunkDataModule>>> WAITING_FOR_INIT = new Long2ObjectLinkedOpenHashMap();
        private final Long2ObjectLinkedOpenHashMap<ChunkDataModule> data = new Long2ObjectLinkedOpenHashMap();
        private final Set<ChunkDataModule> shutoffLoaders = new HashSet<ChunkDataModule>();
        private final Map<UUID, LongOpenHashSet> forcedChunksByUUID = new HashMap<UUID, LongOpenHashSet>();
        private final class_3218 level;
        protected boolean configReloaded = false;
        private int tickCounter = 0;
        private static final int purgeTimer = 2000;

        public synchronized void markChunkOwnedBy(long longChunkPos, @Nullable UUID uuid) {
            if (uuid == null) {
                uuid = class_156.field_25140;
            }
            this.forcedChunksByUUID.computeIfAbsent(uuid, k -> new LongOpenHashSet()).add(longChunkPos);
        }

        public synchronized void markChunkNotOwnedBy(long longChunkPos, @Nullable UUID uuid) {
            if (uuid == null) {
                uuid = class_156.field_25140;
            }
            if (this.forcedChunksByUUID.containsKey(uuid)) {
                LongOpenHashSet set = this.forcedChunksByUUID.get(uuid);
                set.remove(longChunkPos);
                if (set.isEmpty()) {
                    this.forcedChunksByUUID.remove(uuid);
                }
            }
        }

        public synchronized int getCountLoadedChunksOf(@NotNull UUID owner) {
            return this.forcedChunksByUUID.getOrDefault(owner, new LongOpenHashSet()).size();
        }

        public LevelChunkLoaderManager(@NotNull class_3218 level) {
            this.level = level;
            level.method_8503().method_3742(this::tick);
        }

        @NotNull
        public ChunkDataModule getOrCreateData(@NotNull class_1923 pos) {
            return this.getOrCreateData(pos.method_8324());
        }

        public void addChunkLoader(IChunkLoader loader, class_1923 pos) {
            this.addChunkLoader(loader, pos.method_8324());
        }

        public synchronized void addChunkLoader(IChunkLoader loader, long pos) {
            ChunkDataModule cdm = this.getOrCreateData(pos);
            if (loader instanceof IOwnable) {
                this.markChunkOwnedBy(pos, ((IOwnable)((Object)loader)).getOwner());
            }
            cdm.consumeLoadState(previous -> {
                if (cdm.addLoader(this.level, loader)) {
                    cdm.updateChunkLoadState(this.level, (ILoadState)previous);
                }
                this.method_80();
            });
        }

        public void removeChunkLoader(IChunkLoader loader, class_1923 pos) {
            this.removeChunkLoader(loader, pos.method_8324());
        }

        public synchronized void removeChunkLoader(IChunkLoader loader, long pos) {
            ChunkDataModule cdm = this.getOrCreateData(pos);
            cdm.consumeLoadState(previous -> {
                if (cdm.removeLoader(this.level, loader)) {
                    cdm.updateChunkLoadState(this.level, (ILoadState)previous);
                }
                this.method_80();
            });
        }

        @NotNull
        public synchronized ChunkDataModule getOrCreateData(long pos) {
            ChunkDataModule cdm = (ChunkDataModule)this.data.computeIfAbsent(pos, ChunkDataModule::new);
            this.method_80();
            return cdm;
        }

        public void load(class_2487 tag) {
            for (String key : tag.method_10541()) {
                long index = Long.parseLong(key);
                class_1923 pos = new class_1923(index);
                ChunkDataModule module = this.getOrCreateData(index);
                module.consumeLoadState(previous -> {
                    module.load(tag.method_10562(key), this.level);
                    module.update();
                    if (module.onCooldown()) {
                        this.shutDown(pos, (ILoadState)previous);
                    } else {
                        module.getLoadState().apply(this.level, pos, (ILoadState)previous);
                    }
                });
            }
        }

        @NotNull
        public synchronized class_2487 method_75(@NotNull class_2487 compoundTag) {
            this.data.forEach((k, v) -> {
                if (v.shouldPersist()) {
                    compoundTag.method_10566(String.valueOf(k), (class_2520)v.save());
                }
            });
            return compoundTag;
        }

        public synchronized void tick() {
            if (this.configReloaded) {
                for (ChunkDataModule cdm : this.getChunkDataModules()) {
                    cdm.consumeLoadState(previous -> {
                        cdm.update();
                        cdm.updateChunkLoadState(this.level, (ILoadState)previous);
                    });
                }
                this.configReloaded = false;
            }
            if (this.tickCounter >= 2000) {
                this.data.values().removeIf(module -> !module.shouldPersist() && !this.level.method_8393(module.getPosition().field_9181, module.getPosition().field_9180));
                this.tickCounter = 0;
            }
            Iterator<ChunkDataModule> iterator = this.shutoffLoaders.iterator();
            while (iterator.hasNext()) {
                ChunkDataModule cdm;
                cdm = iterator.next();
                if (cdm.onCooldown()) continue;
                iterator.remove();
                cdm.consumeLoadState(previous -> {
                    cdm.update();
                    if (cdm.getLoadState().shouldLoad()) {
                        cdm.startGrace();
                    }
                    cdm.getLoadState().apply(this.level, cdm.getPosition(), (ILoadState)previous);
                });
            }
            this.method_80();
            ++this.tickCounter;
        }

        public synchronized void shutDown(@NotNull class_1923 chunkPos, @NotNull ILoadState previous) {
            ChunkDataModule module = (ChunkDataModule)this.data.get(chunkPos.method_8324());
            this.shutoffLoaders.add(module);
            module.getLoadState().apply(this.level, chunkPos, previous);
            this.method_80();
        }

        public Collection<ChunkDataModule> getChunkDataModules() {
            return this.data.values();
        }

        public String getLevelName() {
            return ((class_5268)this.level.method_8401()).method_150();
        }

        public synchronized <T extends IChunkLoader> T computeChunkLoaderIfAbsent(class_2338 blockPos, Class<T> type, boolean doAdd, Predicate<T> predicate, Supplier<T> supplier) {
            return this.computeChunkLoaderIfAbsent(new class_1923(blockPos), type, doAdd, predicate, supplier);
        }

        public synchronized <T extends IChunkLoader> T computeChunkLoaderIfAbsent(class_1923 pos, Class<T> type, boolean doAdd, Predicate<T> predicate, Supplier<T> supplier) {
            ChunkDataModule cdm = this.getOrCreateData(pos);
            for (IChunkLoader loader : cdm.getLoaders()) {
                if (loader.getClass() != type || !predicate.test(loader)) continue;
                return (T)loader;
            }
            IChunkLoader out = (IChunkLoader)supplier.get();
            if (doAdd) {
                this.addChunkLoader(out, pos);
            }
            return (T)out;
        }

        public void requestUpdate(class_1923 chunkPos) {
            ChunkDataModule cdm = this.getOrCreateData(chunkPos);
            cdm.consumeLoadState(previous -> cdm.update(() -> cdm.updateChunkLoadState(this.level, (ILoadState)previous)));
        }

        public synchronized void clear() {
            this.data.clear();
        }
    }
}

