/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.loaders.extension;

import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import net.minecraft.class_1923;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IExtensionChunkLoader<T extends IChunkLoader>
extends IChunkLoader {
    @Nullable
    default public T getPrimaryHostLoader() {
        return this.getHost(0);
    }

    default public int getExtensionDistance() {
        T loader = this.getPrimaryHostLoader();
        if (loader != null) {
            class_1923 host = loader.getChunkPos();
            class_1923 extension = this.getChunkPos();
            return Math.max(Math.abs(host.field_9181 - extension.field_9181), Math.abs(host.field_9180 - extension.field_9180));
        }
        return -1;
    }

    public void removeHost(Object var1);

    default public boolean isUnhosted() {
        return this.getNumberOfHosts() <= 0;
    }

    default public boolean isHosted() {
        return this.getNumberOfHosts() > 0;
    }

    @Override
    default public boolean shouldPersist() {
        return this.isHosted();
    }

    public void addHost(Object var1);

    public T getHost(int var1);

    public int getNumberOfHosts();

    default public boolean willRemoveHost(@NotNull Object host) {
        for (int i = 0; i < this.getNumberOfHosts(); ++i) {
            if (this.getHost(i) != host) continue;
            return true;
        }
        return false;
    }

    default public void removeHostAndUnload(class_3218 level, @NotNull Object host) {
        if (this.willRemoveHost(host) && this.getNumberOfHosts() <= 1) {
            ChunkDataManager.removeChunkLoader(level, this.getChunkPos(), (IChunkLoader)this);
        }
        this.removeHost(host);
    }

    @Override
    default public ILoadState getActiveState() {
        if (this.isHosted()) {
            ILoadState state = LoadStateRegistry.DISABLED;
            for (int i = 0; i < this.getNumberOfHosts(); ++i) {
                state = this.getHost(i).getActiveState().getSuperiorLoadState(state);
            }
            return state;
        }
        return LoadStateRegistry.DISABLED;
    }
}

