/*
 * Decompiled with CFR 0.152.
 */
package eu.infomas.annotation;

import eu.infomas.annotation.FileIterator;
import eu.infomas.annotation.ResourceIterator;
import eu.infomas.annotation.ZipFileIterator;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;

public final class ClassFileIterator
extends ResourceIterator {
    private final FileIterator fileIterator;
    private final String[] pkgNameFilter;
    private ZipFileIterator zipIterator;

    ClassFileIterator() {
        this(ClassFileIterator.classPath(), null);
    }

    public ClassFileIterator(File[] filesOrDirectories, String[] pkgNameFilter) {
        this.fileIterator = new FileIterator(filesOrDirectories);
        this.pkgNameFilter = pkgNameFilter;
    }

    public String getName() {
        return this.zipIterator == null ? this.fileIterator.getFile().getPath() : this.zipIterator.getEntry().getName();
    }

    @Override
    public InputStream next() throws IOException {
        InputStream is;
        while (true) {
            if (this.zipIterator == null) {
                File file = this.fileIterator.next();
                if (file == null || !file.isFile()) {
                    return null;
                }
                String name = file.getName();
                if (name.endsWith(".class")) {
                    return new FileInputStream(file);
                }
                if (!this.fileIterator.isRootFile() || !ClassFileIterator.endsWithIgnoreCase(name, ".jar") && !this.isZipFile(file)) continue;
                this.zipIterator = new ZipFileIterator(new ZipFile(file), this.pkgNameFilter);
                continue;
            }
            is = this.zipIterator.next();
            if (is != null) break;
            this.zipIterator = null;
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFile(File file) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            int n = ((DataInputStream)in).readInt();
            boolean bl = n == 1347093252;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static File[] classPath() {
        String[] fileNames = System.getProperty("java.class.path").split(File.pathSeparator);
        File[] files = new File[fileNames.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(fileNames[i]);
        }
        return files;
    }

    private static boolean endsWithIgnoreCase(String value, String suffix) {
        int n = suffix.length();
        return value.regionMatches(true, value.length() - n, suffix, 0, n);
    }
}

