package com.drathonix.loadmychunks.common.block;


import com.mojang.serialization.MapCodec;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityChunkLoader;
import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.loaders.IHasChunkloader;
import com.drathonix.loadmychunks.common.util.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockChunkLoader extends class_2237 {
    //? if >1.20.3 {
    public static final MapCodec<BlockChunkLoader> CODEC = method_54094(BlockChunkLoader::new);

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return field_46280;
    }
    //?}

    public BlockChunkLoader(class_2251 properties) {
        super(properties);
    }

    @Override
    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_1309 livingEntity, class_1799 itemStack) {
        super.method_9567(level, blockPos, blockState, livingEntity, itemStack);
        if(livingEntity instanceof class_3222){
            class_2586 entity = level.method_8321(blockPos);
            if(entity instanceof BlockEntityChunkLoader) {
                ((BlockEntityChunkLoader) entity).setOwner(livingEntity.method_5667());
                if(ChunkDataManager.hasExceededOwnershipCap(livingEntity.method_5667())){
                    Message.send((class_3222) livingEntity,Message.styled(Message.translatable("loadmychunks.message.too_many_loaded_chunks", LMCConfig.limitSettings.limit,ChunkDataManager.getCountLoadedChunksOf(livingEntity.method_5667())), class_124.field_1061,true,true));
                }
            }
        }
    }

    public void method_9536(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean isMoving) {
        BlockEntityChunkLoader blockEntity = (BlockEntityChunkLoader) level.method_8321(blockPos);
        IHasChunkloader.ifPresent(blockEntity,loader->{
            int k = loader.getExtensionRange();
            class_2371<class_1799> out = class_2371.method_10211();
            while(k > 0){
                int j = Math.min(64,k);
                k-=j;
                out.add(new class_1799(LMCContent.itemExtension.get(),j));
            }
            if(loader.getDefaultState() == LoadStateRegistry.ENTITY_TICKING) {
                out.add(new class_1799(LMCContent.itemLifeforceBroadcaster.get()));
            }
            class_1264.method_17349(level,blockPos, out);
        });
        super.method_9536(blockState, level, blockPos, blockState2, isMoving);
    }

    /*@Override
    public @NotNull ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        ItemStack itemStack = super.getCloneItemStack(levelReader, blockPos, blockState);
        levelReader.getBlockEntity(blockPos, LMCContent.chunkLoaderBlockEntity.get()).ifPresent((loader) -> {
            loader.saveToItem(itemStack, levelReader.registryAccess());
        });
        return itemStack;
    }*/

    @Override
    public @NotNull class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    //? if >1.16.5 {
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new BlockEntityChunkLoader(blockPos,blockState);
    }
    //?}

    //? if <=1.16.5 {
    /*@Nullable
    @Override
    public BlockEntity newBlockEntity(BlockGetter blockGetter) {
        return new BlockEntityChunkLoader();
    }
    *///?}
}
