package com.drathonix.loadmychunks.common.mixin;

import com.drathonix.loadmychunks.common.bridge.IChunkMapMixin;
import com.drathonix.loadmychunks.common.bridge.ILevelChunkMixin;
import com.drathonix.loadmychunks.common.bridge.ILevelMixin;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_10209;
import net.minecraft.class_1937;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3695;
import net.minecraft.class_5562;

@Mixin(value = class_1937.class,priority = 0)
public abstract class MixinLevel implements ILevelMixin {
    //? if >1.16.5 {
    @Shadow @Final protected List<class_5562> blockEntityTickers;


    @Shadow public abstract boolean isClientSide();
    @Unique private static final Iterator<class_5562> lmc$emptyIter = Collections.emptyIterator();

    //? if <1.21.2 {
    /*@Shadow public abstract ProfilerFiller getProfiler();
    *///?} else {
    public class_3695 getProfiler(){
        return class_10209.method_64146();
    }
    //?}
    /**
     * Overrides the default block ticking logic by ticking each chunk's tile entities in groups rather than all TEs individually.
     */
    @Redirect(method = "tickBlockEntities",at = @At(value = "INVOKE", target = "Ljava/util/List;iterator()Ljava/util/Iterator;"))
    public Iterator<class_5562> tickChunkWise(List<class_5562> instance){
        if(!this.isClientSide()){
            //noinspection resource
            if (loadMyChunks$cast().method_8398() instanceof class_3215 scc) {
                Long2ObjectLinkedOpenHashMap<class_3193> updatingChunkMap = ((IChunkMapMixin) scc.field_17254).lmc$getUpdatingChunkMap();
                synchronized (updatingChunkMap) {
                    for (class_3193 value : updatingChunkMap.values()) {
                        if (value != null && value.method_16144() instanceof ILevelChunkMixin chunk) {
                            if (scc.field_17254.method_17263().method_38632(chunk.loadMyChunks$posAsLong())) {
                                chunk.loadMyChunks$tick();
                            }
                        }
                    }
                }
            }
            return lmc$emptyIter;
        } else {
            return instance.iterator();
        }
    }

    @Override
    public void loadMyChunks$removeTicker(class_5562 tickingBlockEntity) {
        blockEntityTickers.remove(tickingBlockEntity);
    }

    @Unique
    public class_1937 loadMyChunks$cast(){
        return class_1937.class.cast(this);
    }
    //?}

    //TODO: Remove redundancies
    //? if <=1.16.5 {

    /*@Unique private static final Iterator<BlockEntity> lmc$emptyIter = Collections.emptyIterator();

    @Shadow public abstract boolean isClientSide();

    @Shadow @Final public List<BlockEntity> tickableBlockEntities;

    @Shadow @Final public List<BlockEntity> blockEntityList;

    @Shadow public abstract ProfilerFiller getProfiler();

    /^*
     * Overrides the default block ticking logic by ticking each chunk's tile entities in groups rather than all TEs individually.
     *
     * @return An empty list to spoof the original method
     ^/
    //TODO: investigate if this has significant mod conflicts.
    @Redirect(method = "tickBlockEntities",at = @At(value = "INVOKE",target = "Ljava/util/List;iterator()Ljava/util/Iterator;"))
    public Iterator<BlockEntity> tickChunkWise(List<BlockEntity> instance){
        if(!this.isClientSide()) {
            //noinspection resource
            if (loadMyChunks$cast().getChunkSource() instanceof ServerChunkCache) {
                ServerChunkCache scc = (ServerChunkCache) loadMyChunks$cast().getChunkSource();
                Long2ObjectLinkedOpenHashMap<ChunkHolder> updatingChunkMap = ((IChunkMapMixin) scc.chunkMap).lmc$getUpdatingChunkMap();
                for (ChunkHolder value : updatingChunkMap.values()) {
                    if(value != null) {
                        LevelChunk tickingChunk = value.getTickingChunk();
                        if (tickingChunk instanceof ILevelChunkMixin) {
                            if (scc.isTickingChunk(tickingChunk.getPos().getWorldPosition())) {
                                ((ILevelChunkMixin)tickingChunk).loadMyChunks$tick(getProfiler());
                            }
                        }
                    }
                }
            }
            return lmc$emptyIter;
        }
        else{
            return instance.iterator();
        }
    }

    @Override
    public void loadMyChunks$removeTicker(BlockEntity tickingBlockEntity) {
        tickableBlockEntities.remove(tickingBlockEntity);
        blockEntityList.remove(tickingBlockEntity);
    }

    @Unique
    public Level loadMyChunks$cast(){
        return Level.class.cast(this);
    }
    *///?}
}
