package com.drathonix.loadmychunks.common.util;

import com.drathonix.loadmychunks.common.LoadMyChunks;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Convenience class for making resource locations easily.
 */
public class ModResource {
    /**
     * Makes a resource location "modid:string"
     * @param string the key
     * @return a resource location.
     */
    public static @NotNull class_2960 of(@NotNull String string){
        //? if <1.20.7
        /*return new ResourceLocation(LoadMyChunks.MOD_ID,string);*/
        //? if >1.20.6
        return class_2960.method_60655(LoadMyChunks.MOD_ID,string);
    }

    /**
     * Parses a resource location.
     * @param string the resource location string
     * @return a parsed resource location.
     */
    public static @Nullable class_2960 parse(@NotNull String string) {
        //? if <1.20.7 {
        /*try {
            return new ResourceLocation(string);
        } catch(Throwable t){
            return null;
        }
        *///?} else {
        return class_2960.method_12829(string);
        //?}
    }
}
